/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.BoundingBoxMeshView;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OccupancyMapMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.SLAMFrameStateViewer;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class SLAMMeshViewer {
    private static final int SLOW_PACE_UPDATE_PERIOD = 2000;
    private static final int MEDIUM_PACE_UPDATE_PERIOD = 100;
    private static final int HIGH_PACE_UPDATE_PERIOD = 50;
    private final Group root = new Group();
    private final List<ScheduledFuture<?>> meshBuilderScheduledFutures = new ArrayList();
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)5, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private final AnimationTimer renderMeshAnimation;
    private final OccupancyMapMeshBuilder occupancyMapViewer;
    private final BoundingBoxMeshView boundingBoxMeshView;
    private final SLAMFrameStateViewer latestFrameStateViewer;
    private final List<AtomicReference<Boolean>> enableTopicList = new ArrayList<AtomicReference<Boolean>>();
    private final Map<AtomicReference<Boolean>, Node> enableTopicToNode = new HashMap<AtomicReference<Boolean>, Node>();

    public SLAMMeshViewer(REAUIMessager uiMessager) {
        this.occupancyMapViewer = new OccupancyMapMeshBuilder(uiMessager);
        this.latestFrameStateViewer = new SLAMFrameStateViewer(uiMessager, SLAMModuleAPI.ShowLatestFrame, SLAMModuleAPI.SLAMVizClear, REAModuleAPI.UIStereoVisionSize);
        this.boundingBoxMeshView = new BoundingBoxMeshView(uiMessager, SLAMModuleAPI.UIOcTreeBoundingBoxShow, SLAMModuleAPI.RequestBoundingBox, SLAMModuleAPI.OcTreeBoundingBoxState);
        this.occupancyMapViewer.getRoot().setMouseTransparent(true);
        this.boundingBoxMeshView.setMouseTransparent(true);
        this.latestFrameStateViewer.getRoot().setMouseTransparent(true);
        this.root.getChildren().addAll((Object[])new Node[]{this.occupancyMapViewer.getRoot(), this.latestFrameStateViewer.getRoot(), this.boundingBoxMeshView});
        this.addViewer(uiMessager, this.occupancyMapViewer.getRoot(), SLAMModuleAPI.ShowSLAMOctreeMap);
        this.addViewer(uiMessager, this.latestFrameStateViewer.getRoot(), SLAMModuleAPI.ShowLatestFrame);
        this.renderMeshAnimation = new AnimationTimer(){

            public void handle(long now) {
                SLAMMeshViewer.this.occupancyMapViewer.render();
                SLAMMeshViewer.this.latestFrameStateViewer.render();
            }
        };
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                this.start();
            } else {
                this.stop();
            }
        });
    }

    private void addViewer(REAUIMessager uiMessager, Node node, MessagerAPIFactory.Topic<Boolean> enableTopic) {
        AtomicReference<Boolean> enable = uiMessager.createInput(enableTopic, false);
        this.enableTopicToNode.put(enable, node);
        this.enableTopicList.add(enable);
    }

    private Runnable createViewersController() {
        return new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < SLAMMeshViewer.this.enableTopicList.size(); ++i) {
                            AtomicReference<Boolean> enable = SLAMMeshViewer.this.enableTopicList.get(i);
                            Node node = SLAMMeshViewer.this.enableTopicToNode.get(enable);
                            if (enable.get().booleanValue()) {
                                if (SLAMMeshViewer.this.root.getChildren().contains((Object)node)) continue;
                                SLAMMeshViewer.this.root.getChildren().addAll((Object[])new Node[]{node});
                                continue;
                            }
                            if (!SLAMMeshViewer.this.root.getChildren().contains((Object)node)) continue;
                            SLAMMeshViewer.this.root.getChildren().removeAll((Object[])new Node[]{node});
                        }
                    }
                });
            }
        };
    }

    public void start() {
        if (!this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.start();
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.occupancyMapViewer, 0L, 2000L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.latestFrameStateViewer, 0L, 100L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.createViewersController(), 0L, 50L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.boundingBoxMeshView, 0L, 100L, TimeUnit.MILLISECONDS));
    }

    public void sleep() {
        if (this.meshBuilderScheduledFutures.isEmpty()) {
            return;
        }
        this.renderMeshAnimation.stop();
        for (ScheduledFuture<?> scheduledFuture : this.meshBuilderScheduledFutures) {
            scheduledFuture.cancel(true);
        }
        this.meshBuilderScheduledFutures.clear();
    }

    public void stop() {
        this.sleep();
    }

    public Node getRoot() {
        return this.root;
    }
}

