/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.tools;

import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionPublicNetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class ConstantPlanarRegionsPublisher {
    private final PlanarRegionsList planarRegionsList;
    private final ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)this.getClass().getSimpleName());
    private final REAPlanarRegionPublicNetworkProvider publisher;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)1, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> scheduled;
    private final RegionFeaturesProvider featuresProvider = new ConstantPlanarRegionProvider();

    public ConstantPlanarRegionsPublisher(PlanarRegionsList planarRegionsList) {
        this.planarRegionsList = planarRegionsList;
        this.publisher = new REAPlanarRegionPublicNetworkProvider((ROS2NodeInterface)this.ros2Node, REACommunicationProperties.outputTopic, REACommunicationProperties.lidarOutputTopic, REACommunicationProperties.stereoOutputTopic, REACommunicationProperties.depthOutputTopic);
    }

    public void start() {
        this.start(200);
    }

    public void start(int periodMillis) {
        if (this.scheduled == null) {
            this.scheduled = this.executorService.scheduleAtFixedRate(() -> this.publisher.update(this.featuresProvider, true, null), 0L, periodMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public static void main(String[] args) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        int returnVal = fileChooser.showOpenDialog(new JFrame());
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile().getParentFile();
            PlanarRegionsList planarRegionsList = PlanarRegionFileTools.importPlanarRegionData((File)file);
            new ConstantPlanarRegionsPublisher(planarRegionsList).start();
        }
    }

    private class ConstantPlanarRegionProvider
    implements RegionFeaturesProvider {
        private ConstantPlanarRegionProvider() {
        }

        @Override
        public List<PlanarRegionSegmentationNodeData> getSegmentationNodeData() {
            return null;
        }

        @Override
        public PlanarRegionsList getPlanarRegionsList() {
            return ConstantPlanarRegionsPublisher.this.planarRegionsList;
        }

        @Override
        public int getNumberOfPlaneIntersections() {
            return 0;
        }

        @Override
        public LineSegment3D getIntersection(int index) {
            return null;
        }
    }
}

