/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.PerceptionSuiteAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;

public class PerceptionSuiteUI {
    private final Pane mainPane;
    private final Stage primaryStage;
    private final REAUIMessager messager;
    @FXML
    private ToggleButton runSlamModule;
    @FXML
    private ToggleButton runSlamUI;
    @FXML
    private ToggleButton runLidarREAModule;
    @FXML
    private ToggleButton runLidarREAUI;
    @FXML
    private ToggleButton runMapSegmentationModule;
    @FXML
    private ToggleButton runMapSegmentationUI;
    @FXML
    private ToggleButton runRealSenseREAModule;
    @FXML
    private ToggleButton runRealSenseREAUI;
    @FXML
    private ToggleButton runLiveMapModule;
    @FXML
    private ToggleButton runLiveMapUI;
    @FXML
    private TextArea errorField;

    private PerceptionSuiteUI(REAUIMessager messager, Stage primaryStage) throws Exception {
        this.messager = messager;
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (Pane)loader.load();
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunRealSenseSLAM, this.runSlamModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunRealSenseSLAMUI, this.runSlamUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunLidarREA, this.runLidarREAModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunLidarREAUI, this.runLidarREAUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunMapSegmentation, this.runMapSegmentationModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunMapSegmentationUI, this.runMapSegmentationUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunRealSenseREA, this.runRealSenseREAModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunRealSenseREAUI, this.runRealSenseREAUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunLiveMap, this.runLiveMapModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.GUIRunLiveMapUI, this.runLiveMapUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunRealSenseSLAM, this.runSlamModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunRealSenseSLAMUI, this.runSlamUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunLidarREA, this.runLidarREAModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunLidarREAUI, this.runLidarREAUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunMapSegmentation, this.runMapSegmentationModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunMapSegmentationUI, this.runMapSegmentationUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunRealSenseREA, this.runRealSenseREAModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunRealSenseREAUI, this.runRealSenseREAUI.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunLiveMap, this.runLiveMapModule.selectedProperty());
        messager.bindBidirectionalGlobal(PerceptionSuiteAPI.RunLiveMapUI, this.runLiveMapUI.selectedProperty());
        messager.registerTopicListener(PerceptionSuiteAPI.ErrorMessage, arg_0 -> ((TextArea)this.errorField).setText(arg_0));
        primaryStage.setTitle(this.getClass().getSimpleName());
        Scene mainScene = new Scene((Parent)this.mainPane, 594.0, 200.0);
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    public void clearError() {
        this.errorField.clear();
    }

    public void show() throws IOException {
        this.primaryStage.show();
    }

    public void stop() {
    }

    public static PerceptionSuiteUI createIntraprocessUI(Stage primaryStage, Messager messager) throws Exception {
        REAUIMessager uiMessager = new REAUIMessager(messager);
        uiMessager.startMessager();
        return new PerceptionSuiteUI(uiMessager, primaryStage);
    }
}

