/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;

public class UIConnectionHandler {
    private final AtomicBoolean enable = new AtomicBoolean(false);
    private final Window mainWindow;
    private final REAUIMessager uiMessager;
    private final MessagerAPIFactory.Topic<Boolean> requestEntireModuleState;

    public UIConnectionHandler(Window mainWindow, REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> requestEntireModuleState) {
        this.mainWindow = mainWindow;
        this.uiMessager = uiMessager;
        this.requestEntireModuleState = requestEntireModuleState == null ? REAModuleAPI.RequestEntireModuleState : requestEntireModuleState;
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                new Thread(() -> {
                    while (!mainWindow.isShowing()) {
                        ThreadTools.sleep((long)100L);
                    }
                    this.refreshUIControls();
                }, "REAUIConnectionHandler").start();
            } else {
                this.displayWarning();
            }
        });
    }

    public UIConnectionHandler(Window mainWindow, REAUIMessager uiMessager) {
        this(mainWindow, uiMessager, null);
    }

    public void start() {
        this.enable.set(true);
    }

    public void stop() {
        this.enable.set(false);
    }

    private void refreshUIControls() {
        if (this.enable.get()) {
            this.uiMessager.submitStateRequestToModule(this.requestEntireModuleState);
        }
    }

    private void displayWarning() {
        if (!this.enable.get()) {
            return;
        }
        Platform.runLater(this::createWarning);
    }

    private void createWarning() {
        Alert connectionLostAlert = new Alert(Alert.AlertType.WARNING);
        connectionLostAlert.setHeaderText("Lost connection");
        connectionLostAlert.initOwner(this.mainWindow);
        connectionLostAlert.showAndWait();
    }
}

