/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomRegionMergeParameters;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.CustomRegionMergeParametersProperty;

public class CustomRegionMergeAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableMergeButton;
    @FXML
    private Slider maxDistanceInPlaneSlider;
    @FXML
    private Slider maxDistanceFromPlaneSlider;
    @FXML
    private Slider maxAngleFromPlaneSlider;
    private final CustomRegionMergeParametersProperty customRegionMergingParametersProperty = new CustomRegionMergeParametersProperty(this, "customRegionMergingParameters");
    private MessagerAPIFactory.Topic<Boolean> customRegionsMergingEnableTopic = REAModuleAPI.CustomRegionsMergingEnable;
    private MessagerAPIFactory.Topic<Boolean> customRegionsClearTopic = REAModuleAPI.CustomRegionsClear;
    private MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic = REAModuleAPI.SaveRegionUpdaterConfiguration;
    private MessagerAPIFactory.Topic<CustomRegionMergeParameters> customRegionsMergingParametersTopic = REAModuleAPI.CustomRegionsMergingParameters;

    private void setupControls() {
        this.maxDistanceInPlaneSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxDistanceFromPlaneSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxAngleFromPlaneSlider.setLabelFormatter(StringConverterTools.radiansToRoundedDegrees());
    }

    public void setCustomRegionsMergingEnableTopic(MessagerAPIFactory.Topic<Boolean> customRegionsMergingEnableTopic) {
        this.customRegionsMergingEnableTopic = customRegionsMergingEnableTopic;
    }

    public void setCustomRegionsClearTopic(MessagerAPIFactory.Topic<Boolean> customRegionsClearTopic) {
        this.customRegionsClearTopic = customRegionsClearTopic;
    }

    public void setSaveRegionUpdaterConfigurationTopic(MessagerAPIFactory.Topic<Boolean> saveRegionUpdaterConfigurationTopic) {
        this.saveRegionUpdaterConfigurationTopic = saveRegionUpdaterConfigurationTopic;
    }

    public void setCustomRegionsMergingParametersTopic(MessagerAPIFactory.Topic<CustomRegionMergeParameters> customRegionsMergingParametersTopic) {
        this.customRegionsMergingParametersTopic = customRegionsMergingParametersTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.customRegionsMergingEnableTopic, this.enableMergeButton.selectedProperty());
        this.customRegionMergingParametersProperty.bindBidirectionalSearchRadius((Property<? extends Number>)this.maxDistanceInPlaneSlider.valueProperty());
        this.customRegionMergingParametersProperty.bindBidirectionalMaxDistanceFromPlane((Property<? extends Number>)this.maxDistanceFromPlaneSlider.valueProperty());
        this.customRegionMergingParametersProperty.bindBidirectionalMaxAngleFromPlane((Property<? extends Number>)this.maxAngleFromPlaneSlider.valueProperty());
        this.uiMessager.bindBidirectionalGlobal(this.customRegionsMergingParametersTopic, this.customRegionMergingParametersProperty);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(this.saveRegionUpdaterConfigurationTopic);
    }

    @FXML
    public void clear() {
        this.uiMessager.submitMessageToModule(this.customRegionsClearTopic, true);
    }
}

