/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.SurfaceNormalFilterParameters;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;

public class OcTreeBasicsAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableButton;
    @FXML
    private Button clearButton;
    @FXML
    private Slider depthSlider;
    @FXML
    private Slider resolutionSlider;
    @FXML
    private Spinner<Double> nodeLifetimeSpinner;
    @FXML
    private ComboBox<OcTreeMeshBuilder.DisplayType> displayTypeComboBox;
    @FXML
    private ComboBox<OcTreeMeshBuilder.ColoringType> coloringTypeComboBox;
    @FXML
    private Slider lidarBufferSizeSlider;
    @FXML
    private ToggleButton enableLidarBufferButton;
    @FXML
    private ToggleButton showLidarBufferButton;
    @FXML
    private ToggleButton showInputLidarScanButton;
    @FXML
    private ToggleButton showStereoBufferButton;
    @FXML
    private Slider stereoBufferMessageSizeSlider;
    @FXML
    private Slider stereoBufferSizeSlider;
    @FXML
    private ToggleButton enableStereoBufferButton;
    @FXML
    private ToggleButton preserveStereoOcTreeHistoryButton;
    @FXML
    private ToggleButton showInputStereoFrameButton;
    @FXML
    private ToggleButton showDepthBufferButton;
    @FXML
    private ToggleButton enableDepthBufferButton;
    @FXML
    private Slider depthBufferMessageSizeSlider;
    @FXML
    private Slider depthBufferSizeSlider;
    @FXML
    private ToggleButton preserveDepthOcTreeHistoryButton;
    @FXML
    private ToggleButton showInputDepthCloudButton;
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number> numberToIntegerConverter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number>(){

        public Integer convert(Number propertyValue) {
            return propertyValue.intValue();
        }

        public Number interpret(Integer newValue) {
            return new Double(newValue.doubleValue());
        }
    };
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number> numberToDoubleConverter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number>(){

        public Double convert(Number propertyValue) {
            return propertyValue.doubleValue();
        }

        public Number interpret(Double newValue) {
            return new Double(newValue);
        }
    };
    private MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic = REAModuleAPI.OcTreeEnable;

    public void setupControls() {
        this.nodeLifetimeSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 86400.0, 60.0, 5.0));
        ObservableList displayTypeOptions = FXCollections.observableArrayList((Object[])OcTreeMeshBuilder.DisplayType.values());
        this.displayTypeComboBox.setItems(displayTypeOptions);
        this.displayTypeComboBox.setValue((Object)OcTreeMeshBuilder.DisplayType.PLANE);
        ObservableList coloringTypeOptions = FXCollections.observableArrayList((Object[])OcTreeMeshBuilder.ColoringType.values());
        this.coloringTypeComboBox.setItems(coloringTypeOptions);
        this.coloringTypeComboBox.setValue((Object)OcTreeMeshBuilder.ColoringType.REGION);
        this.lidarBufferSizeSlider.setLabelFormatter(StringConverterTools.thousandRounding((boolean)true));
        Tooltip tooltip = new Tooltip();
        tooltip.setText("Press Clear Btn to apply the change of Octree resolution");
        this.resolutionSlider.setTooltip(tooltip);
    }

    public void setOcTreeEnableTopic(MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic) {
        this.ocTreeEnableTopic = ocTreeEnableTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.ocTreeEnableTopic, this.enableButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.OcTreeResolution, this.resolutionSlider.valueProperty(), this.numberToDoubleConverter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.OcTreeNodeLifetimeMillis, this.nodeLifetimeSpinner.getValueFactory().valueProperty(), this.millisecondToSecondTimeConverter());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.LidarBufferEnable, this.enableLidarBufferButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.LidarBufferOcTreeCapacity, this.lidarBufferSizeSlider.valueProperty(), this.numberToIntegerConverter);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIOcTreeShowLidarBuffer, this.showLidarBufferButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UILidarScanShow, this.showInputLidarScanButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.StereoVisionBufferEnable, this.enableStereoBufferButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.StereoVisionBufferMessageCapacity, this.stereoBufferMessageSizeSlider.valueProperty(), this.numberToIntegerConverter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.StereoVisionBufferSize, this.stereoBufferSizeSlider.valueProperty(), this.numberToIntegerConverter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.StereoVisionBufferPreservingEnable, this.preserveStereoOcTreeHistoryButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.UIOcTreeShowStereoVisionBuffer, this.showStereoBufferButton.selectedProperty());
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIStereoVisionShow, this.showInputStereoFrameButton.selectedProperty(), true);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.DepthCloudBufferEnable, this.enableDepthBufferButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.DepthCloudBufferMessageCapacity, this.depthBufferMessageSizeSlider.valueProperty(), this.numberToIntegerConverter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.DepthCloudBufferSize, this.depthBufferSizeSlider.valueProperty(), this.numberToIntegerConverter);
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.DepthCloudBufferPreservingEnable, this.preserveDepthOcTreeHistoryButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.UIOcTreeShowDepthCloudBuffer, this.showDepthBufferButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(REAModuleAPI.UIDepthCloudShow, this.showInputDepthCloudButton.selectedProperty());
        this.load();
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIOcTreeDepth, this.depthSlider.valueProperty(), this.numberToIntegerConverter, true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox.valueProperty(), true);
        this.uiMessager.bindBidirectionalInternal(REAModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox.valueProperty(), true);
        this.showInputLidarScanButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != newValue && !newValue.booleanValue()) {
                this.uiMessager.submitMessageInternal(REAModuleAPI.UILidarScanClear, true);
                this.uiMessager.submitMessageInternal(REAModuleAPI.UIDepthCloudClear, true);
                this.uiMessager.submitMessageInternal(REAModuleAPI.UIStereoVisionClear, true);
            }
        });
    }

    @FXML
    public void clear() {
        this.uiMessager.broadcastMessage(REAModuleAPI.OcTreeClear, true);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(REAModuleAPI.SaveMainUpdaterConfiguration);
        this.uiMessager.submitStateRequestToModule(REAModuleAPI.SaveBufferConfiguration);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeDepth, this.depthSlider);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeShowLidarBuffer, this.showLidarBufferButton);
        this.saveUIControlProperty(REAModuleAPI.UILidarScanShow, this.showInputLidarScanButton);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeShowStereoVisionBuffer, this.showStereoBufferButton);
        this.saveUIControlProperty(REAModuleAPI.UIOcTreeShowDepthCloudBuffer, this.showDepthBufferButton);
        this.saveUIControlProperty(REAModuleAPI.UIStereoVisionShow, this.showInputStereoFrameButton);
        this.saveUIControlProperty(REAModuleAPI.UIDepthCloudShow, this.showInputDepthCloudButton);
    }

    public void load() {
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeDepth, this.depthSlider);
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox);
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox);
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeShowLidarBuffer, this.showLidarBufferButton);
        this.loadUIControlProperty(REAModuleAPI.UILidarScanShow, this.showInputLidarScanButton);
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeShowStereoVisionBuffer, this.showStereoBufferButton);
        this.loadUIControlProperty(REAModuleAPI.UIOcTreeShowDepthCloudBuffer, this.showDepthBufferButton);
        this.loadUIControlProperty(REAModuleAPI.UIStereoVisionShow, this.showInputStereoFrameButton);
        this.loadUIControlProperty(REAModuleAPI.UIDepthCloudShow, this.showInputDepthCloudButton);
    }

    public void setParametersForStereo() {
        BoundingBoxParametersMessage boundingBoxMessage = new BoundingBoxParametersMessage();
        boundingBoxMessage.setMaxX(1.0f);
        boundingBoxMessage.setMinX(0.0f);
        boundingBoxMessage.setMaxY(1.0f);
        boundingBoxMessage.setMinY(-1.0f);
        boundingBoxMessage.setMaxZ(1.0f);
        boundingBoxMessage.setMinZ(-2.0f);
        this.uiMessager.broadcastMessage(REAModuleAPI.LidarBufferEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.StereoVisionBufferEnable, true);
        this.uiMessager.broadcastMessage(REAModuleAPI.DepthCloudBufferEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.OcTreeBoundingBoxEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.OcTreeBoundingBoxParameters, boundingBoxMessage);
        NormalEstimationParameters normalEstimationParameters = new NormalEstimationParameters();
        normalEstimationParameters.setNumberOfIterations(7);
        this.uiMessager.broadcastMessage(REAModuleAPI.NormalEstimationParameters, normalEstimationParameters);
        PlanarRegionSegmentationParameters planarRegionSegmentationParameters = new PlanarRegionSegmentationParameters();
        planarRegionSegmentationParameters.setMaxDistanceFromPlane(0.03);
        planarRegionSegmentationParameters.setMaxAngleFromPlane(Math.toRadians(10.0));
        planarRegionSegmentationParameters.setMinRegionSize(150);
        this.uiMessager.broadcastMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, planarRegionSegmentationParameters);
        SurfaceNormalFilterParameters surfaceNormalFilterParameters = new SurfaceNormalFilterParameters();
        surfaceNormalFilterParameters.setUseSurfaceNormalFilter(true);
        surfaceNormalFilterParameters.setSurfaceNormalLowerBound(Math.toRadians(-40.0));
        surfaceNormalFilterParameters.setSurfaceNormalUpperBound(Math.toRadians(40.0));
        this.uiMessager.broadcastMessage(REAModuleAPI.SurfaceNormalFilterParameters, surfaceNormalFilterParameters);
        PolygonizerParameters polygonizerParameters = new PolygonizerParameters();
        polygonizerParameters.setConcaveHullThreshold(0.15);
        this.uiMessager.broadcastMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, REAParametersMessageHelper.convertToMessage(polygonizerParameters));
    }

    public void setParametersForDepth() {
        BoundingBoxParametersMessage boundindBoxMessage = new BoundingBoxParametersMessage();
        boundindBoxMessage.setMaxX(1.0f);
        boundindBoxMessage.setMinX(0.0f);
        boundindBoxMessage.setMaxY(1.0f);
        boundindBoxMessage.setMinY(-1.0f);
        boundindBoxMessage.setMaxZ(1.0f);
        boundindBoxMessage.setMinZ(-2.0f);
        this.uiMessager.broadcastMessage(REAModuleAPI.LidarBufferEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.StereoVisionBufferEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.DepthCloudBufferEnable, true);
        this.uiMessager.broadcastMessage(REAModuleAPI.OcTreeBoundingBoxEnable, false);
        this.uiMessager.broadcastMessage(REAModuleAPI.OcTreeBoundingBoxParameters, boundindBoxMessage);
        this.uiMessager.broadcastMessage(REAModuleAPI.UIOcTreeDisplayType, OcTreeMeshBuilder.DisplayType.HIDE);
    }

    private MessageBidirectionalBinding.PropertyToMessageTypeConverter<Long, Double> millisecondToSecondTimeConverter() {
        return new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Long, Double>(){

            public Long convert(Double lifetimeSeconds) {
                return (long)(1000.0 * lifetimeSeconds);
            }

            public Double interpret(Long lifetimeMillis) {
                return 0.001 * (double)lifetimeMillis.longValue();
            }
        };
    }
}

