/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import java.io.File;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleButton;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;

public abstract class REABasicUIController {
    protected REAUIMessager uiMessager;
    private FilePropertyHelper filePropertyHelper;

    public abstract void bindControls();

    public void attachREAMessager(REAUIMessager uiMessager) {
        this.uiMessager = uiMessager;
    }

    public void setConfigurationFile(File configurationFile) {
        this.filePropertyHelper = new FilePropertyHelper(configurationFile);
    }

    protected void saveUIControlProperty(MessagerAPIFactory.Topic<Boolean> topic, ToggleButton toggleButton) {
        this.filePropertyHelper.saveProperty(topic.getName(), toggleButton.isSelected());
    }

    protected <T> void saveUIControlProperty(MessagerAPIFactory.Topic<T> topic, ComboBox<T> comboBox) {
        this.filePropertyHelper.saveProperty(topic.getName(), comboBox.getValue().toString());
    }

    protected void saveUIControlProperty(MessagerAPIFactory.Topic<? extends Number> topic, Slider slider) {
        this.filePropertyHelper.saveProperty(topic.getName(), slider.getValue());
    }

    protected void loadUIControlProperty(MessagerAPIFactory.Topic<Boolean> topic, ToggleButton toggleButton) {
        Boolean loadedProperty = this.filePropertyHelper.loadBooleanProperty(topic.getName());
        if (loadedProperty != null) {
            toggleButton.setSelected(loadedProperty.booleanValue());
        }
    }

    protected void loadUIControlProperty(MessagerAPIFactory.Topic<? extends Number> topic, Slider slider) {
        Double loadedProperty = this.filePropertyHelper.loadDoubleProperty(topic.getName());
        if (loadedProperty != null) {
            slider.setValue(loadedProperty.doubleValue());
        }
    }

    protected void loadUIControlProperty(MessagerAPIFactory.Topic<Double> topic, Spinner<Double> spinner) {
        Double loadedProperty = this.filePropertyHelper.loadDoubleProperty(topic.getName());
        if (loadedProperty != null) {
            spinner.getValueFactory().setValue((Object)loadedProperty);
        }
    }

    protected <T extends Enum<T>> void loadUIControlProperty(MessagerAPIFactory.Topic<T> topic, ComboBox<T> comboBox) {
        String loadedProperty = this.filePropertyHelper.loadProperty(topic.getName());
        if (loadedProperty != null) {
            Object valueOf = Enum.valueOf(((Enum)comboBox.getItems().get(0)).getClass(), loadedProperty);
            comboBox.setValue(valueOf);
        }
    }
}

