/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import java.io.File;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;

public class StereoDataExporterAnchorPaneController
extends REABasicUIController {
    private final File defaultStereoDataFile = new File("Data/");
    @FXML
    private TextField stereoDataFolderTextField;
    @FXML
    private ToggleButton exportRecodingStereoButton;
    private final DirectoryChooser stereoDirectoryChooser = new DirectoryChooser();
    private Window ownerWindow;
    private MessagerAPIFactory.Topic<Boolean> uiStereoDataExportRequestTopic = REAModuleAPI.UIStereoDataExportRequest;
    private MessagerAPIFactory.Topic<String> uiStereoDataExporterDirectoryTopic = REAModuleAPI.UIStereoDataExporterDirectory;

    public void setMainWindow(Window ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    public void setUIStereoDataExportRequestTopic(MessagerAPIFactory.Topic<Boolean> uiStereoDataExportRequestTopic) {
        this.uiStereoDataExportRequestTopic = uiStereoDataExportRequestTopic;
    }

    public void setUiStereoDataExporterDirectoryTopic(MessagerAPIFactory.Topic<String> uiStereoDataExporterDirectoryTopic) {
        this.uiStereoDataExporterDirectoryTopic = uiStereoDataExporterDirectoryTopic;
    }

    @Override
    public void bindControls() {
        this.stereoDataFolderTextField.setText(this.defaultStereoDataFile.getAbsolutePath());
        this.uiMessager.bindBidirectionalGlobal(this.uiStereoDataExportRequestTopic, this.exportRecodingStereoButton.selectedProperty());
    }

    @FXML
    private void browseStereoOutputFolder() {
        this.stereoDirectoryChooser.setInitialDirectory(this.defaultStereoDataFile);
        String newPath = this.stereoDirectoryChooser.showDialog(this.ownerWindow).getAbsolutePath();
        this.uiMessager.submitMessageInternal(this.uiStereoDataExporterDirectoryTopic, newPath);
        Platform.runLater(() -> this.stereoDataFolderTextField.setText(newPath));
    }
}

