/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import gnu.trove.list.array.TByteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import perception_msgs.msg.dds.LidarScanMessage;
import us.ihmc.communication.packets.LidarPointCloudCompression;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.AbstractSourceViewer;

public class LidarScanViewer
extends AbstractSourceViewer<LidarScanMessage> {
    private final AtomicReference<Integer> numberOfScans;
    private final AtomicInteger currentScanIndex = new AtomicInteger(0);
    private static final Material defaultMaterial = new PhongMaterial(Color.DARKRED);

    public LidarScanViewer(MessagerAPIFactory.Topic<LidarScanMessage> messageState, REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> enableTopic, MessagerAPIFactory.Topic<Boolean> clearTopic) {
        super(messageState, uiMessager, enableTopic, clearTopic);
        this.numberOfScans = uiMessager.createInput(REAModuleAPI.UILidarScanSize, 50);
    }

    @Override
    public void render() {
        MeshView newScanMeshView = this.scanMeshToRender.getAndSet(null);
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
            this.currentScanIndex.set(0);
        }
        while (this.children.size() > this.numberOfScans.get()) {
            this.children.remove(this.children.size() - 1);
        }
        if (!((Boolean)this.enable.get()).booleanValue()) {
            return;
        }
        if (newScanMeshView != null) {
            if (this.children.size() <= this.currentScanIndex.get()) {
                this.children.add((Object)newScanMeshView);
            } else {
                this.children.set(this.currentScanIndex.get(), (Object)newScanMeshView);
            }
            for (int i = this.currentScanIndex.get() + 1; i < this.currentScanIndex.get() + this.children.size(); ++i) {
                ((MeshView)this.children.get(i % this.children.size())).setMaterial(defaultMaterial);
            }
            this.currentScanIndex.set((this.currentScanIndex.get() + 1) % this.numberOfScans.get());
        }
    }

    @Override
    public void unpackPointCloud(LidarScanMessage message) {
        if (message == null) {
            return;
        }
        Point3D32 scanPoint = new Point3D32();
        this.meshBuilder.clear();
        int numberOfScanPoints = message.getNumberOfPoints();
        LidarPointCloudCompression.decompressPointCloud((TByteArrayList)message.getScan(), (int)numberOfScanPoints, (i, x, y, z) -> {
            double alpha = (double)i / (double)numberOfScanPoints;
            Color color = Color.hsb((double)(alpha * 240.0), (double)1.0, (double)1.0);
            scanPoint.set(x, y, z);
            this.meshBuilder.addMesh(MeshDataGenerator.Tetrahedron((float)0.0075f), (Tuple3DReadOnly)scanPoint, color);
        });
        MeshView scanMeshView = new MeshView(this.meshBuilder.generateMesh());
        scanMeshView.setMaterial(this.meshBuilder.generateMaterial());
        this.scanMeshToRender.set(scanMeshView);
        this.meshBuilder.clear();
    }
}

