/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAPlanarRegionsConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.PlanarRegionSegmentationMessage;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class PlanarRegionSegmentationDataExporter {
    private final Executor executor = ExecutorServiceTools.newSingleThreadScheduledExecutor(this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private final AtomicReference<PlanarRegionSegmentationMessage[]> planarRegionSegmentationState;
    private final AtomicReference<String> dataDirectoryPath;

    public PlanarRegionSegmentationDataExporter(REAUIMessager uiMessager) {
        this(uiMessager, REAModuleAPI.PlanarRegionsSegmentationState, REAModuleAPI.UISegmentationDataExporterDirectory, REAModuleAPI.UISegmentationDataExportRequest);
    }

    public PlanarRegionSegmentationDataExporter(REAUIMessager uiMessager, MessagerAPIFactory.Topic<PlanarRegionSegmentationMessage[]> planarSegmentationStateTopic, MessagerAPIFactory.Topic<String> uiSegmentationDataExporterDirectoryTopic, MessagerAPIFactory.Topic<Boolean> uiSegmentationDataExportRequestTopic) {
        this.planarRegionSegmentationState = uiMessager.createInput(planarSegmentationStateTopic);
        this.dataDirectoryPath = uiMessager.createInput(uiSegmentationDataExporterDirectoryTopic, new File("Data/Segmentation/").getAbsolutePath());
        uiMessager.registerTopicListener(uiSegmentationDataExportRequestTopic, this::exportSegmentationData);
    }

    public PlanarRegionSegmentationDataExporter(File dataDirectoryPath) {
        this.planarRegionSegmentationState = new AtomicReference<Object>(null);
        this.dataDirectoryPath = new AtomicReference<String>(dataDirectoryPath.getAbsolutePath());
    }

    public void exportSegmentationRawData(List<PlanarRegionSegmentationRawData> rawData) {
        this.planarRegionSegmentationState.set(PlanarRegionSegmentationRawData.toMessageArray(rawData));
        this.exportSegmentationData(true);
    }

    public void exportSegmentationRawData(PlanarRegionSegmentationRawData rawData) {
        this.planarRegionSegmentationState.set(new PlanarRegionSegmentationMessage[]{rawData.toMessage()});
        this.exportSegmentationData(true);
    }

    public void exportSegmentationData(List<PlanarRegionSegmentationNodeData> nodeData) {
        this.planarRegionSegmentationState.set(REAPlanarRegionsConverter.createPlanarRegionSegmentationMessages(nodeData));
        this.exportSegmentationData(true);
    }

    public void exportSegmentationData(PlanarRegionSegmentationNodeData nodeData) {
        PlanarRegionSegmentationMessage message = REAPlanarRegionsConverter.createPlanarRegionSegmentationMessage(nodeData);
        this.planarRegionSegmentationState.set(new PlanarRegionSegmentationMessage[]{message});
        this.exportSegmentationData(true);
    }

    private void exportSegmentationData(boolean export) {
        PlanarRegionSegmentationMessage[] segmentationData = this.planarRegionSegmentationState.get();
        if (segmentationData != null) {
            this.executor.execute(() -> this.executeOnThread(segmentationData));
        }
    }

    private void executeOnThread(PlanarRegionSegmentationMessage[] segmentationData) {
        Path folderPath = Paths.get(this.dataDirectoryPath.get() + File.separator + PlanarRegionSegmentationDataExporter.getDate() + "PlanarRegionSegmentation", new String[0]);
        try {
            if (folderPath.toFile().exists()) {
                return;
            }
            Files.createDirectories(folderPath, new FileAttribute[0]);
            File header = new File(folderPath.toFile(), "header.txt");
            this.writeHeaderFile(header, segmentationData);
            this.writeRegionData(folderPath, segmentationData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void writeHeaderFile(File header, PlanarRegionSegmentationMessage[] segmentationData) throws IOException {
        FileWriter fileWriter = new FileWriter(header);
        for (PlanarRegionSegmentationMessage message : segmentationData) {
            Point3D32 origin = message.getOrigin();
            Vector3D32 normal = message.getNormal();
            fileWriter.write("regionId: ");
            fileWriter.write(Integer.toString(message.getRegionId()));
            fileWriter.write(", origin: ");
            fileWriter.write(origin.getX() + ", " + origin.getY() + ", " + origin.getZ());
            fileWriter.write(", normal: ");
            fileWriter.write(normal.getX() + ", " + normal.getY() + ", " + normal.getZ());
            fileWriter.write("\n");
        }
        fileWriter.close();
    }

    private void writeRegionData(Path folderPath, PlanarRegionSegmentationMessage[] segmentationData) throws IOException {
        for (PlanarRegionSegmentationMessage message : segmentationData) {
            File regionFile = new File(folderPath.toFile(), "region" + message.getRegionId());
            FileWriter fileWriter = new FileWriter(regionFile);
            for (Point3D32 hitLocation : message.getHitLocations()) {
                fileWriter.write(hitLocation.getX() + ", " + hitLocation.getY() + ", " + hitLocation.getZ() + "\n");
            }
            fileWriter.close();
        }
    }

    private static String getDate() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_");
        return LocalDateTime.now().format(dateTimeFormatter);
    }
}

