/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.io;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class StereoVisionPointCloudDataExporter {
    private static final long recodingFrequency = 500L;
    public static final String POINT_CLOUD_FILE_NAME_HEADER = "stereo";
    public static final String SENSOR_POSE_FILE_NAME_HEADER = "pose";
    public static final String STEREO_DATA_SPLITER = "_";
    public static final String STEREO_DATA_EXTENSION = ".txt";
    private final ScheduledExecutorService executorService = ExecutorServiceTools.newSingleThreadScheduledExecutor(this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> activeRecordingTask = null;
    private final AtomicReference<StereoVisionPointCloudMessage> stereovisionPointCloudMessage;
    private final AtomicReference<String> dataDirectoryPath;

    public StereoVisionPointCloudDataExporter(REAUIMessager uiMessager) {
        this(uiMessager, REAModuleAPI.DepthPointCloudState, REAModuleAPI.UIStereoDataExporterDirectory, REAModuleAPI.UIStereoDataExportRequest);
    }

    public StereoVisionPointCloudDataExporter(REAUIMessager uiMessager, MessagerAPIFactory.Topic<StereoVisionPointCloudMessage> depthPointCloudStateTopic, MessagerAPIFactory.Topic<String> uiStereoDataExporterDirectoryTopic, MessagerAPIFactory.Topic<Boolean> uiStereoDataExportRequestTopic) {
        this.stereovisionPointCloudMessage = uiMessager.createInput(depthPointCloudStateTopic);
        this.dataDirectoryPath = uiMessager.createInput(uiStereoDataExporterDirectoryTopic, new File("Data/").getAbsolutePath());
        uiMessager.registerTopicListener(uiStereoDataExportRequestTopic, this::toggleRecording);
    }

    private void toggleRecording(boolean enable) {
        if (enable) {
            if (this.activeRecordingTask != null) {
                return;
            }
            this.activeRecordingTask = this.executorService.scheduleAtFixedRate(this::record, 0L, 500L, TimeUnit.MILLISECONDS);
        } else {
            if (this.activeRecordingTask == null) {
                return;
            }
            this.activeRecordingTask.cancel(false);
            this.activeRecordingTask = null;
        }
    }

    private void record() {
        StereoVisionPointCloudMessage message = this.stereovisionPointCloudMessage.get();
        if (message == null) {
            return;
        }
        Point3D[] pointCloud = StereoPointCloudCompression.decompressPointCloudToArray((StereoVisionPointCloudMessage)message);
        Path path = Paths.get(this.dataDirectoryPath.get(), new String[0]);
        StereoVisionPointCloudDataExporter.saveSensorPose(path, message.timestamp_, message.getSensorPosition(), message.getSensorOrientation());
        StereoVisionPointCloudDataExporter.savePointCloud(path, message.timestamp_, pointCloud, StereoPointCloudCompression.decompressColorsToIntArray((StereoVisionPointCloudMessage)message));
    }

    public void shutdown() {
        if (this.activeRecordingTask != null) {
            this.activeRecordingTask.cancel(false);
        }
        this.executorService.shutdown();
    }

    private static void saveSensorPose(Path path, long timestamp, Point3D sensorPosition, Quaternion sensorOrientation) {
        File sensorPoseFile = new File(path.toFile(), "pose_" + timestamp + STEREO_DATA_EXTENSION);
        try {
            FileWriter sensorPoseFileWriter = new FileWriter(sensorPoseFile);
            StringBuilder builder = new StringBuilder("");
            builder.append(sensorPosition.getX() + "\t" + sensorPosition.getY() + "\t" + sensorPosition.getZ() + "\t");
            builder.append(sensorOrientation.getX() + "\t" + sensorOrientation.getY() + "\t" + sensorOrientation.getZ() + "\t" + sensorOrientation.getS());
            sensorPoseFileWriter.write(builder.toString());
            sensorPoseFileWriter.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static void savePointCloud(Path path, long timestamp, Point3D[] pointCloud, int[] colors) {
        File pointCloudFile = new File(path.toFile(), "stereo_" + timestamp + STEREO_DATA_EXTENSION);
        try {
            FileWriter pointCloudFileWriter = new FileWriter(pointCloudFile);
            StringBuilder builder = new StringBuilder("");
            for (int i = 0; i < colors.length; ++i) {
                Point3D scanPoint = pointCloud[i];
                int color = colors[i];
                builder.append(i + "\t" + scanPoint.getX() + "\t" + scanPoint.getY() + "\t" + scanPoint.getZ() + "\t" + color + "\n");
            }
            pointCloudFileWriter.write(builder.toString());
            pointCloudFileWriter.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

