/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import map_sense.RawGPUPlanarRegionList;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.GPUPerceptionModuleAPI;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.updaters.GPUPlanarRegionUpdater;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.tools.thread.ExecutorServiceTools;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RawGPUPlanarRegionSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class GPUBasedREAModule
implements PerceptionModule {
    private static final int THREAD_PERIOD_MILLISECONDS = 100;
    private final Messager messager;
    private final ROS2Node ros2Node;
    private final RosMainNode rosMainNode;
    private RawGPUPlanarRegionList rawGPUPlanarRegionList;
    private ScheduledFuture<?> scheduled;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)1, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private final GPUPlanarRegionUpdater gpuPlanarRegionUpdater = new GPUPlanarRegionUpdater();
    private final RawGPUPlanarRegionSubscriber gpuPlanarRegionSubscriber = new RawGPUPlanarRegionSubscriber();

    public GPUBasedREAModule(Messager messager, ROS2Node ros2Node, RosMainNode rosMainNode) {
        this.rosMainNode = rosMainNode;
        this.ros2Node = ros2Node;
        this.messager = messager;
        rosMainNode.attachSubscriber("/mapsense/planar_regions", (RosTopicSubscriberInterface)this.gpuPlanarRegionSubscriber);
    }

    void mainUpdate() {
        if (this.gpuPlanarRegionSubscriber.regionListIsAvailable()) {
            this.rawGPUPlanarRegionList = this.gpuPlanarRegionSubscriber.getRawPlanarRegionList();
            PlanarRegionsList regionList = this.gpuPlanarRegionUpdater.generatePlanarRegions(this.rawGPUPlanarRegionList);
            this.messager.submitMessage(GPUPerceptionModuleAPI.PlanarRegionData, (Object)regionList);
        }
    }

    @Override
    public void start() {
        if (this.scheduled == null) {
            this.scheduled = this.executorService.scheduleAtFixedRate(this::mainUpdate, 0L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public static GPUBasedREAModule createIntraprocess(Messager messager, ROS2Node ros2Node, RosMainNode rosMainNode) throws URISyntaxException {
        return new GPUBasedREAModule(messager, ros2Node, rosMainNode);
    }
}

