/*
 * Copyright 2017 Florida Institute for Human and Machine Cognition (IHMC)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package us.ihmc.rosidl;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;

/**
 * Helper class to unmarshall ROS2 Package xml files.
 * 
 * @author Jesper Smith
 *
 */
@XmlRootElement(name = "package")
public class RosPackage
{
   /**
    * Name of the package
    */
   private String name;
   
   /**
    * Build dependencies
    */
   private List<String> build_depend;

   public String getName()
   {
      return name;
   }

   @XmlElement
   public void setName(String name)
   {
      this.name = name;
   }

   public List<String> getBuild_depend()
   {
      return build_depend;
   }

   @XmlElement
   public void setBuild_depend(List<String> build_depend)
   {
      this.build_depend = build_depend;
   }
   
   
}
