/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateReadOnly;

public interface SphericalJointStateBasics
extends SphericalJointStateReadOnly,
JointStateBasics {
    public QuaternionBasics getOrientation();

    public Vector3DBasics getAngularVelocity();

    public Vector3DBasics getAngularAcceleration();

    public Vector3DBasics getTorque();

    @Override
    default public void clear() {
        this.getOrientation().setToNaN();
        this.getAngularVelocity().setToNaN();
        this.getAngularAcceleration().setToNaN();
        this.getTorque().setToNaN();
    }

    default public void setConfiguration(Orientation3DReadOnly configuration) {
        this.getOrientation().set(configuration);
    }

    default public void setVelocity(Vector3DReadOnly angularVelocity) {
        this.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
    }

    default public void setAcceleration(Vector3DReadOnly angularAcceleration) {
        this.getAngularAcceleration().set((Tuple3DReadOnly)angularAcceleration);
    }

    default public void setEffort(Vector3DReadOnly torque) {
        this.getTorque().set((Tuple3DReadOnly)torque);
    }

    default public void set(SphericalJointStateReadOnly other) {
        this.setConfiguration((Orientation3DReadOnly)other.getOrientation());
        this.setVelocity(other.getAngularVelocity());
        this.setAcceleration(other.getAngularAcceleration());
        this.setEffort(other.getTorque());
    }

    @Override
    default public void setConfiguration(JointReadOnly joint) {
        this.getOrientation().set(((SphericalJointReadOnly)joint).getJointOrientation());
    }

    @Override
    default public void setVelocity(JointReadOnly joint) {
        this.getAngularVelocity().set((Tuple3DReadOnly)((SphericalJointReadOnly)joint).getJointAngularVelocity());
    }

    @Override
    default public void setAcceleration(JointReadOnly joint) {
        this.getAngularAcceleration().set((Tuple3DReadOnly)((SphericalJointReadOnly)joint).getJointAngularAcceleration());
    }

    @Override
    default public void setEffort(JointReadOnly joint) {
        this.getTorque().set((Tuple3DReadOnly)((SphericalJointReadOnly)joint).getJointTorque());
    }

    @Override
    default public int setConfiguration(int startRow, DMatrix configuration) {
        this.getOrientation().set(startRow, configuration);
        return startRow + this.getConfigurationSize();
    }

    @Override
    default public int setVelocity(int startRow, DMatrix velocity) {
        this.getAngularVelocity().set(startRow, velocity);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    default public int setAcceleration(int startRow, DMatrix acceleration) {
        this.getAngularAcceleration().set(startRow, acceleration);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    default public int setEffort(int startRow, DMatrix effort) {
        this.getTorque().set(startRow, effort);
        return startRow + this.getDegreesOfFreedom();
    }
}

