/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import java.util.Objects;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class ConvexPolytope3DDefinition
extends GeometryDefinition {
    private ConvexPolytope3DReadOnly convexPolytope;

    public ConvexPolytope3DDefinition() {
        this.setName("convexPolytope3D");
    }

    public ConvexPolytope3DDefinition(ConvexPolytope3DReadOnly convexPolytope) {
        this();
        this.convexPolytope = convexPolytope;
    }

    public ConvexPolytope3DDefinition(ConvexPolytope3DDefinition other) {
        this.setName(other.getName());
        if (other.convexPolytope != null) {
            this.convexPolytope = new ConvexPolytope3D(other.convexPolytope);
        }
    }

    public void setConvexPolytope(ConvexPolytope3DReadOnly convexPolytope) {
        this.convexPolytope = convexPolytope;
    }

    public ConvexPolytope3DReadOnly getConvexPolytope() {
        return this.convexPolytope;
    }

    @Override
    public ConvexPolytope3DDefinition copy() {
        return new ConvexPolytope3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.convexPolytope);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ConvexPolytope3DDefinition other = (ConvexPolytope3DDefinition)object;
        return Objects.equals(this.convexPolytope, other.convexPolytope);
    }

    public String toString() {
        return "Convex Polytope: [name: " + this.getName() + ", " + this.convexPolytope + "]";
    }
}

