/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public abstract class OneDoFJointDefinition
extends JointDefinition {
    private Vector3D axis = new Vector3D();
    private double positionLowerLimit = Double.NEGATIVE_INFINITY;
    private double positionUpperLimit = Double.POSITIVE_INFINITY;
    private double velocityLowerLimit = Double.NEGATIVE_INFINITY;
    private double velocityUpperLimit = Double.POSITIVE_INFINITY;
    private double effortLowerLimit = Double.NEGATIVE_INFINITY;
    private double effortUpperLimit = Double.POSITIVE_INFINITY;
    private double damping = -1.0;
    private double stiction = -1.0;
    private double kpSoftLimitStop = -1.0;
    private double kdSoftLimitStop = -1.0;
    private double dampingVelocitySoftLimit = -1.0;
    private OneDoFJointState initialJointState;

    public OneDoFJointDefinition() {
    }

    public OneDoFJointDefinition(String name) {
        super(name);
    }

    public OneDoFJointDefinition(String name, Tuple3DReadOnly offsetFromParent, Vector3DReadOnly axis) {
        super(name, offsetFromParent);
        this.setAxis(axis);
    }

    public OneDoFJointDefinition(OneDoFJointDefinition other) {
        super(other);
        this.axis.set(other.axis);
        this.positionLowerLimit = other.positionLowerLimit;
        this.positionUpperLimit = other.positionUpperLimit;
        this.velocityLowerLimit = other.velocityLowerLimit;
        this.velocityUpperLimit = other.velocityUpperLimit;
        this.effortLowerLimit = other.effortLowerLimit;
        this.effortUpperLimit = other.effortUpperLimit;
        this.damping = other.damping;
        this.stiction = other.stiction;
        this.kpSoftLimitStop = other.kpSoftLimitStop;
        this.kdSoftLimitStop = other.kdSoftLimitStop;
        this.dampingVelocitySoftLimit = other.dampingVelocitySoftLimit;
        this.initialJointState = other.initialJointState == null ? null : other.initialJointState.copy();
    }

    @XmlElement
    public void setAxis(Vector3D axis) {
        this.axis = axis;
    }

    public void setAxis(Vector3DReadOnly axis) {
        this.axis.set((Tuple3DReadOnly)axis);
    }

    public Vector3D getAxis() {
        return this.axis;
    }

    @XmlElement
    public void setPositionLowerLimit(double positionLowerLimit) {
        this.positionLowerLimit = positionLowerLimit;
    }

    @XmlElement
    public void setPositionUpperLimit(double positionUpperLimit) {
        this.positionUpperLimit = positionUpperLimit;
    }

    public void setPositionLimits(double lowerLimit, double upperLimit) {
        this.setPositionLowerLimit(lowerLimit);
        this.setPositionUpperLimit(upperLimit);
    }

    public double getPositionLowerLimit() {
        return this.positionLowerLimit;
    }

    public double getPositionUpperLimit() {
        return this.positionUpperLimit;
    }

    @XmlElement
    public void setVelocityLowerLimit(double velocityLowerLimit) {
        this.velocityLowerLimit = velocityLowerLimit;
    }

    @XmlElement
    public void setVelocityUpperLimit(double velocityUpperLimit) {
        this.velocityUpperLimit = velocityUpperLimit;
    }

    public void setVelocityLimits(double lowerLimit, double upperLimit) {
        this.setVelocityLowerLimit(lowerLimit);
        this.setVelocityUpperLimit(upperLimit);
    }

    public void setVelocityLimits(double limit) {
        this.setVelocityLowerLimit(-limit);
        this.setVelocityUpperLimit(limit);
    }

    public double getVelocityLowerLimit() {
        return this.velocityLowerLimit;
    }

    public double getVelocityUpperLimit() {
        return this.velocityUpperLimit;
    }

    @XmlElement
    public void setEffortLowerLimit(double effortLowerLimit) {
        this.effortLowerLimit = effortLowerLimit;
    }

    @XmlElement
    public void setEffortUpperLimit(double effortUpperLimit) {
        this.effortUpperLimit = effortUpperLimit;
    }

    public void setEffortLimits(double lowerLimit, double upperLimit) {
        this.setEffortLowerLimit(lowerLimit);
        this.setEffortUpperLimit(upperLimit);
    }

    public void setEffortLimits(double limit) {
        this.setEffortLowerLimit(-limit);
        this.setEffortUpperLimit(limit);
    }

    public double getEffortLowerLimit() {
        return this.effortLowerLimit;
    }

    public double getEffortUpperLimit() {
        return this.effortUpperLimit;
    }

    @XmlElement
    public void setStiction(double stiction) {
        this.stiction = stiction;
    }

    public double getStiction() {
        return this.stiction;
    }

    @XmlElement
    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getDamping() {
        return this.damping;
    }

    @XmlElement
    public void setKpSoftLimitStop(double kpSoftLimitStop) {
        this.kpSoftLimitStop = kpSoftLimitStop;
    }

    @XmlElement
    public void setKdSoftLimitStop(double kdSoftLimitStop) {
        this.kdSoftLimitStop = kdSoftLimitStop;
    }

    public void setGainsSoftLimitStop(double kpSoftLimitStop, double kdSoftLimitStop) {
        this.kpSoftLimitStop = kpSoftLimitStop;
        this.kdSoftLimitStop = kdSoftLimitStop;
    }

    public double getKpSoftLimitStop() {
        return this.kpSoftLimitStop;
    }

    public double getKdSoftLimitStop() {
        return this.kdSoftLimitStop;
    }

    @XmlElement
    public void setDampingVelocitySoftLimit(double dampingVelocitySoftLimit) {
        this.dampingVelocitySoftLimit = dampingVelocitySoftLimit;
    }

    public double getDampingVelocitySoftLimit() {
        return this.dampingVelocitySoftLimit;
    }

    public void setInitialJointState(double q) {
        if (this.initialJointState == null) {
            this.setInitialJointState(new OneDoFJointState());
        }
        this.initialJointState.setConfiguration(q);
    }

    public void setInitialJointState(double q, double qd) {
        if (this.initialJointState == null) {
            this.setInitialJointState(new OneDoFJointState());
        }
        this.initialJointState.setConfiguration(q);
        this.initialJointState.setVelocity(qd);
    }

    public void setInitialJointState(OneDoFJointState initialJointState) {
        this.initialJointState = initialJointState;
    }

    @Override
    public void setInitialJointState(JointStateReadOnly initialJointState) {
        if (initialJointState instanceof OneDoFJointState) {
            this.setInitialJointState((OneDoFJointState)initialJointState);
        } else if (this.initialJointState == null) {
            this.initialJointState = new OneDoFJointState(initialJointState);
        } else {
            this.initialJointState.set(initialJointState);
        }
    }

    @Override
    public OneDoFJointState getInitialJointState() {
        return this.initialJointState;
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.axis);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.positionLowerLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.positionUpperLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.velocityLowerLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.velocityUpperLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.effortLowerLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.effortUpperLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.damping);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.stiction);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.kpSoftLimitStop);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.kdSoftLimitStop);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.dampingVelocitySoftLimit);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.initialJointState);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        OneDoFJointDefinition other = (OneDoFJointDefinition)object;
        if (!Objects.equals(this.axis, other.axis)) {
            return false;
        }
        if (Double.doubleToLongBits(this.positionLowerLimit) != Double.doubleToLongBits(other.positionLowerLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.positionUpperLimit) != Double.doubleToLongBits(other.positionUpperLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.velocityLowerLimit) != Double.doubleToLongBits(other.velocityLowerLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.velocityUpperLimit) != Double.doubleToLongBits(other.velocityUpperLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.effortLowerLimit) != Double.doubleToLongBits(other.effortLowerLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.effortUpperLimit) != Double.doubleToLongBits(other.effortUpperLimit)) {
            return false;
        }
        if (Double.doubleToLongBits(this.damping) != Double.doubleToLongBits(other.damping)) {
            return false;
        }
        if (Double.doubleToLongBits(this.stiction) != Double.doubleToLongBits(other.stiction)) {
            return false;
        }
        if (Double.doubleToLongBits(this.kpSoftLimitStop) != Double.doubleToLongBits(other.kpSoftLimitStop)) {
            return false;
        }
        if (Double.doubleToLongBits(this.kdSoftLimitStop) != Double.doubleToLongBits(other.kdSoftLimitStop)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dampingVelocitySoftLimit) != Double.doubleToLongBits(other.dampingVelocitySoftLimit)) {
            return false;
        }
        return Objects.equals(this.initialJointState, other.initialJointState);
    }
}

