/*
 * Decompiled with CFR 0.152.
 */
package us.jsy.redact;

import com.codahale.metrics.annotation.Timed;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.jsy.redact.Saying;

@Path(value="/hello-world")
@Produces(value={"application/json"})
public class HelloWorldResource {
    private static final Logger logger = LoggerFactory.getLogger(HelloWorldResource.class);
    private final String template;
    private final String defaultName;
    private final AtomicLong counter;

    public HelloWorldResource(String template, String defaultName) {
        this.template = template;
        this.defaultName = defaultName;
        this.counter = new AtomicLong();
    }

    @GET
    @Timed
    public Saying sayHello(@QueryParam(value="name") Optional<String> name) {
        logger.debug("name: {}", name);
        String value = String.format(this.template, name.orElse(this.defaultName));
        logger.info("say: {}", (Object)value);
        return new Saying(this.counter.incrementAndGet(), value);
    }
}

