/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.cvss.CvssV2;
import us.springett.cvss.CvssV3;
import us.springett.cvss.Score;

public interface Cvss {
    public static final Pattern CVSSv2_PATTERN = Pattern.compile("AV:[NAL]\\/AC:[LMH]\\/A[Uu]:[NSM]\\/C:[NPC]\\/I:[NPC]\\/A:[NPC]");
    public static final Pattern CVSSv3_PATTERN = Pattern.compile("AV:[NALP]\\/AC:[LH]\\/PR:[NLH]\\/UI:[NR]\\/S:[UC]\\/C:[NLH]\\/I:[NLH]\\/A:[NLH]");

    public Score calculateScore();

    public String getVector();

    public static Cvss fromVector(String vector) {
        if (vector == null) {
            return null;
        }
        Matcher v2Matcher = CVSSv2_PATTERN.matcher(vector);
        Matcher v3Matcher = CVSSv3_PATTERN.matcher(vector);
        if (v2Matcher.find()) {
            String matchedVector = v2Matcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            CvssV2 cvssV2 = new CvssV2();
            cvssV2.attackVector(CvssV2.AttackVector.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.attackComplexity(CvssV2.AttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.authentication(CvssV2.Authentication.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.confidentiality(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.integrity(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.availability(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
            return cvssV2;
        }
        if (v3Matcher.find()) {
            String matchedVector = v3Matcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            CvssV3 cvssV3 = new CvssV3();
            cvssV3.attackVector(CvssV3.AttackVector.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.attackComplexity(CvssV3.AttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.privilegesRequired(CvssV3.PrivilegesRequired.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.userInteraction(CvssV3.UserInteraction.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.scope(CvssV3.Scope.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.confidentiality(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.integrity(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.availability(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
            return cvssV3;
        }
        return null;
    }
}

