/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import us.springett.cvss.Cvss;
import us.springett.cvss.Score;

public class CvssV2
implements Cvss {
    private AttackVector av;
    private AttackComplexity ac;
    private Authentication au;
    private CIA c;
    private CIA i;
    private CIA a;

    public CvssV2 attackVector(AttackVector av) {
        this.av = av;
        return this;
    }

    public CvssV2 attackComplexity(AttackComplexity ac) {
        this.ac = ac;
        return this;
    }

    public CvssV2 authentication(Authentication au) {
        this.au = au;
        return this;
    }

    public CvssV2 confidentiality(CIA c) {
        this.c = c;
        return this;
    }

    public CvssV2 integrity(CIA i) {
        this.i = i;
        return this;
    }

    public CvssV2 availability(CIA a) {
        this.a = a;
        return this;
    }

    @Override
    public Score calculateScore() {
        double impactSubScore = 10.41 * (1.0 - (1.0 - this.c.weight) * (1.0 - this.i.weight) * (1.0 - this.a.weight));
        double exploitabalitySubScore = 20.0 * this.av.weight * this.ac.weight * this.au.weight;
        double baseScore = this.roundNearestTenth((0.6 * impactSubScore + 0.4 * exploitabalitySubScore - 1.5) * this.f(impactSubScore));
        return new Score(baseScore, this.roundNearestTenth(impactSubScore), this.roundNearestTenth(exploitabalitySubScore));
    }

    private double f(double impact) {
        return impact == 0.0 ? 0.0 : 1.176;
    }

    private double roundNearestTenth(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    @Override
    public String getVector() {
        return "(AV:" + this.av.shorthand + "/AC:" + this.ac.shorthand + "/Au:" + this.au.shorthand + "/C:" + this.c.shorthand + "/I:" + this.i.shorthand + "/A:" + this.a.shorthand + ")";
    }

    public String toString() {
        return this.getVector();
    }

    public static enum CIA {
        NONE(0.0, "N"),
        PARTIAL(0.275, "P"),
        COMPLETE(0.66, "C");

        private final double weight;
        private final String shorthand;

        private CIA(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static CIA fromString(String text) {
            for (CIA e : CIA.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Authentication {
        NONE(0.704, "N"),
        SINGLE(0.56, "S"),
        MULTIPLE(0.45, "M");

        private final double weight;
        private final String shorthand;

        private Authentication(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Authentication fromString(String text) {
            for (Authentication e : Authentication.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackComplexity {
        LOW(0.71, "L"),
        MEDIUM(0.61, "M"),
        HIGH(0.35, "H");

        private final double weight;
        private final String shorthand;

        private AttackComplexity(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackComplexity fromString(String text) {
            for (AttackComplexity e : AttackComplexity.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackVector {
        NETWORK(1.0, "N"),
        ADJACENT(0.646, "A"),
        LOCAL(0.395, "L");

        private final double weight;
        private final String shorthand;

        private AttackVector(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackVector fromString(String text) {
            for (AttackVector e : AttackVector.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }
}

