/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import us.springett.cvss.Cvss;
import us.springett.cvss.Score;

public class CvssV3
implements Cvss {
    private static final double exploitabilityCoefficient = 8.22;
    private static final double scopeCoefficient = 1.08;
    private AttackVector av;
    private AttackComplexity ac;
    private PrivilegesRequired pr;
    private UserInteraction ui;
    private Scope s;
    private CIA c;
    private CIA i;
    private CIA a;

    public CvssV3 attackVector(AttackVector av) {
        this.av = av;
        return this;
    }

    public CvssV3 attackComplexity(AttackComplexity ac) {
        this.ac = ac;
        return this;
    }

    public CvssV3 privilegesRequired(PrivilegesRequired pr) {
        this.pr = pr;
        return this;
    }

    public CvssV3 userInteraction(UserInteraction ui) {
        this.ui = ui;
        return this;
    }

    public CvssV3 scope(Scope s) {
        this.s = s;
        return this;
    }

    public CvssV3 confidentiality(CIA c) {
        this.c = c;
        return this;
    }

    public CvssV3 integrity(CIA i) {
        this.i = i;
        return this;
    }

    public CvssV3 availability(CIA a) {
        this.a = a;
        return this;
    }

    @Override
    public Score calculateScore() {
        double prWeight = Scope.UNCHANGED == this.s ? this.pr.weight : this.pr.scopeChangedWeight;
        double exploitabalitySubScore = 8.22 * this.av.weight * this.ac.weight * prWeight * this.ui.weight;
        double impactSubScoreMultiplier = 1.0 - (1.0 - this.c.weight) * (1.0 - this.i.weight) * (1.0 - this.a.weight);
        double impactSubScore = Scope.UNCHANGED == this.s ? this.s.weight * impactSubScoreMultiplier : this.s.weight * (impactSubScoreMultiplier - 0.029) - 3.25 * Math.pow(impactSubScoreMultiplier - 0.02, 15.0);
        double baseScore = impactSubScore <= 0.0 ? 0.0 : (Scope.UNCHANGED == this.s ? this.roundUp1(Math.min(exploitabalitySubScore + impactSubScore, 10.0)) : this.roundUp1(Math.min((exploitabalitySubScore + impactSubScore) * 1.08, 10.0)));
        return new Score(baseScore, this.roundNearestTenth(impactSubScore), this.roundNearestTenth(exploitabalitySubScore));
    }

    private double roundUp1(double d) {
        return Math.ceil(d * 10.0) / 10.0;
    }

    private double roundNearestTenth(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    @Override
    public String getVector() {
        return "CVSS:3.0/AV:" + this.av.shorthand + "/AC:" + this.ac.shorthand + "/PR:" + this.pr.shorthand + "/UI:" + this.ui.shorthand + "/S:" + this.s.shorthand + "/C:" + this.c.shorthand + "/I:" + this.i.shorthand + "/A:" + this.a.shorthand;
    }

    public String toString() {
        return this.getVector();
    }

    public static enum CIA {
        NONE(0.0, "N"),
        LOW(0.22, "L"),
        HIGH(0.56, "H");

        private final double weight;
        private final String shorthand;

        private CIA(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static CIA fromString(String text) {
            for (CIA e : CIA.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Scope {
        UNCHANGED(6.42, "U"),
        CHANGED(7.52, "C");

        private final double weight;
        private final String shorthand;

        private Scope(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Scope fromString(String text) {
            for (Scope e : Scope.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum UserInteraction {
        NONE(0.85, "N"),
        REQUIRED(0.62, "R");

        private final double weight;
        private final String shorthand;

        private UserInteraction(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static UserInteraction fromString(String text) {
            for (UserInteraction e : UserInteraction.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum PrivilegesRequired {
        NONE(0.85, 0.85, "N"),
        LOW(0.62, 0.68, "L"),
        HIGH(0.27, 0.5, "H");

        private final double weight;
        private final double scopeChangedWeight;
        private final String shorthand;

        private PrivilegesRequired(double weight, double scopeChangedWeight, String shorthand) {
            this.weight = weight;
            this.scopeChangedWeight = scopeChangedWeight;
            this.shorthand = shorthand;
        }

        public static PrivilegesRequired fromString(String text) {
            for (PrivilegesRequired e : PrivilegesRequired.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackComplexity {
        LOW(0.77, "L"),
        HIGH(0.44, "H");

        private final double weight;
        private final String shorthand;

        private AttackComplexity(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackComplexity fromString(String text) {
            for (AttackComplexity e : AttackComplexity.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackVector {
        NETWORK(0.85, "N"),
        ADJACENT(0.62, "A"),
        LOCAL(0.55, "L"),
        PHYSICAL(0.2, "P");

        private final double weight;
        private final String shorthand;

        private AttackVector(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackVector fromString(String text) {
            for (AttackVector e : AttackVector.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }
}

