/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.core.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uy.klutter.core.uri.ImmutableUri;
import uy.klutter.core.uri.UrlEncoding;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.TRAIT_IMPL)
public final class ImmutableUri$$TImpl {
    public static boolean hasPath(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.getEncodedPath();
        return string != null ? KotlinPackage.isNotBlank((String)string) : false;
    }

    public static boolean hasQuery(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.getEncodedQuery();
        return string != null ? KotlinPackage.isNotBlank((String)string) : false;
    }

    public static boolean hasFragment(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.getEncodedFragment();
        return string != null ? KotlinPackage.isNotBlank((String)string) : false;
    }

    public static boolean hasHost(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.getHost();
        return string != null ? KotlinPackage.isNotBlank((String)string) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasPort(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        if ($this.getPort() == null) return false;
        Integer n = $this.getPort();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (((Number)n).intValue() <= 0) return false;
        return true;
    }

    public static boolean hasUserInfo(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.getEncodedUserInfo();
        return string != null ? KotlinPackage.isNotBlank((String)string) : false;
    }

    @NotNull
    public static URI toURI(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        Integer n = $this.getPort();
        return new URI($this.getScheme(), $this.getEncodedUserInfo(), $this.getHost(), n != null ? ((Number)n).intValue() : -1, $this.getEncodedPath(), $this.getEncodedQuery(), $this.getEncodedFragment());
    }

    @NotNull
    public static String toString(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        String string = $this.toURI().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toURI().toString()");
        return string;
    }

    @Nullable
    public static List<String> fragmentAsDecodedPath(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        List<String> list;
        if ($this.getEncodedFragment() == null) {
            list = null;
        } else {
            String string = $this.getEncodedFragment();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            list = UrlEncoding.INSTANCE$.decodePathToSegments(string);
        }
        return list;
    }

    @Nullable
    public static Map<String, List<? extends String>> fragmentAsDecodedQuery(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        Map<String, List<? extends String>> map;
        if ($this.getEncodedFragment() == null) {
            map = null;
        } else {
            String string = $this.getEncodedFragment();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            map = UrlEncoding.INSTANCE$.decodeQueryStringToMultiMap(string);
        }
        return map;
    }

    @Nullable
    public static Map<String, String> fragmentAsDecodedQueryDeduped(@JetValueParameter(name="$this", type="?") ImmutableUri $this) {
        Map<String, String> map;
        if ($this.getEncodedFragment() == null) {
            map = null;
        } else {
            String string = $this.getEncodedFragment();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            map = UrlEncoding.INSTANCE$.decodeQueryToMap(string);
        }
        return map;
    }
}

