/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.auth.aspect;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import vip.mate.core.auth.annotation.PreAuth;
import vip.mate.core.common.entity.LoginUser;
import vip.mate.core.common.exception.TokenException;
import vip.mate.core.common.util.SecurityUtil;
import vip.mate.core.redis.core.RedisService;

@Aspect
@Component
public class PreAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(PreAuthAspect.class);
    private static final String ALL_PERMISSION = "*:*:*";
    private final HttpServletRequest request;
    private final RedisService redisService;

    @Around(value="@annotation(vip.mate.core.auth.annotation.PreAuth)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        PreAuth preAuth = method.getAnnotation(PreAuth.class);
        if (ObjectUtils.isEmpty((Object)preAuth)) {
            return point.proceed();
        }
        if (this.hasPerm(preAuth.hasPerm())) {
            return point.proceed();
        }
        throw new TokenException("\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
    }

    public boolean hasPerm(String permission) {
        LoginUser userInfo = SecurityUtil.getUsername((HttpServletRequest)this.request);
        if (StringUtils.isEmpty((Object)userInfo)) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)userInfo) && StringUtils.isEmpty((Object)permission)) {
            return true;
        }
        if (userInfo.getAccount().equalsIgnoreCase("admin")) {
            return true;
        }
        Map data = (Map)this.redisService.get("mate.permission." + userInfo.getAccount() + "." + userInfo.getRoleId());
        List authorities = (List)data.get("permissions");
        return this.hasPermissions(authorities, permission);
    }

    private boolean hasPermissions(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)permission, (String)x));
    }

    public PreAuthAspect(HttpServletRequest request, RedisService redisService) {
        this.request = request;
        this.redisService = redisService;
    }
}

