/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.database.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import org.apache.ibatis.type.EnumTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import vip.mate.core.common.factory.YamlPropertySourceFactory;
import vip.mate.core.database.handler.MateMetaObjectHandler;
import vip.mate.core.database.props.TenantProperties;
import vip.mate.core.mybatis.injector.MateSqlInjector;
import vip.mate.core.mybatis.interceptor.SqlLogInterceptor;
import vip.mate.core.mybatis.props.MateMybatisProperties;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties(value={MateMybatisProperties.class})
@PropertySource(factory=YamlPropertySourceFactory.class, value={"classpath:mate-db.yml"})
@MapperScan(value={"vip.mate.**.mapper.**"})
public class MybatisPlusConfiguration {
    private final TenantProperties tenantProperties;
    private final TenantLineInnerInterceptor tenantLineInnerInterceptor;
    private static final Long MAX_LIMIT = 1000L;

    @Bean
    public ISqlInjector sqlInjector() {
        return new MateSqlInjector();
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-plus.sql-log.enable"}, matchIfMissing=true)
    public SqlLogInterceptor sqlLogInterceptor() {
        return new SqlLogInterceptor();
    }

    @Bean
    public MybatisPlusInterceptor paginationInterceptor() {
        boolean enableTenant = this.tenantProperties.getEnable();
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (enableTenant) {
            interceptor.addInnerInterceptor((InnerInterceptor)this.tenantLineInnerInterceptor);
        }
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setMaxLimit(MAX_LIMIT);
        BlockAttackInnerInterceptor blockAttackInnerInterceptor = new BlockAttackInnerInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)blockAttackInnerInterceptor);
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={MateMetaObjectHandler.class})
    public MateMetaObjectHandler mateMetaObjectHandler() {
        return new MateMetaObjectHandler();
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> {
            configuration.setDefaultEnumTypeHandler(EnumTypeHandler.class);
            configuration.setLogPrefix("log.mybatis");
        };
    }

    @Bean
    public OptimisticLockerInnerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    public MybatisPlusConfiguration(TenantProperties tenantProperties, TenantLineInnerInterceptor tenantLineInnerInterceptor) {
        this.tenantProperties = tenantProperties;
        this.tenantLineInnerInterceptor = tenantLineInnerInterceptor;
    }
}

