/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.database.config;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import vip.mate.core.common.context.TenantContextHolder;
import vip.mate.core.database.config.MybatisPlusConfiguration;
import vip.mate.core.database.props.TenantProperties;

@Configuration
@AutoConfigureBefore(value={MybatisPlusConfiguration.class})
@EnableConfigurationProperties(value={TenantProperties.class})
public class TenantConfiguration {
    private final TenantProperties tenantProperties;

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenant = TenantContextHolder.getTenantId();
                if (tenant != null) {
                    return new StringValue(TenantContextHolder.getTenantId());
                }
                return new NullValue();
            }

            public String getTenantIdColumn() {
                return TenantConfiguration.this.tenantProperties.getColumn();
            }

            public boolean ignoreTable(String tableName) {
                return TenantConfiguration.this.tenantProperties.getIgnoreTables().stream().anyMatch(t -> t.equalsIgnoreCase(tableName));
            }
        });
    }

    public TenantConfiguration(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

