/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.database.datascope;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import vip.mate.core.database.datascope.DataScope;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
@Component
public class DataScopeInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private final DataSource dataSource;

    public Object intercept(Invocation invocation) throws Throwable {
        if (log.isInfoEnabled()) {
            log.debug("\u8fdb\u5165 PrepareInterceptor \u62e6\u622a\u5668...");
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        DataScope dataScope = this.findDataScopeObject(parameterObject);
        if (ObjectUtils.isNull((Object[])new Object[]{dataScope})) {
            return invocation.proceed();
        }
        String scopeName = dataScope.getScopeName();
        List<Integer> deptIds = dataScope.getDepartIds();
        return invocation.proceed();
    }

    private DataScope findDataScopeObject(Object parameterObj) {
        if (parameterObj instanceof DataScope) {
            return (DataScope)parameterObj;
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return (DataScope)val;
            }
        }
        return null;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public DataScopeInterceptor(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

