/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import vip.mate.core.encrypt.enums.EncryptType;
import vip.mate.core.encrypt.exception.EncryptException;
import vip.mate.core.encrypt.handler.EncryptHandler;
import vip.mate.core.encrypt.handler.impl.AesEncryptHandler;
import vip.mate.core.encrypt.handler.impl.Base64EncryptHandler;
import vip.mate.core.encrypt.handler.impl.RsaEncryptHandler;

@Configuration
@EnableAutoConfiguration
public class EncryptConfiguration
implements ApplicationContextAware,
BeanFactoryPostProcessor,
EnvironmentAware {
    private ApplicationContext applicationContext;
    private Environment environment;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        GenericBeanDefinition bean = new GenericBeanDefinition();
        EncryptType type = (EncryptType)((Object)this.environment.getProperty("encrypt.type", EncryptType.class));
        String secret = (String)this.environment.getProperty("encrypt.secret", String.class);
        String publicKey = (String)this.environment.getProperty("encrypt.publicKey", String.class);
        String privateKey = (String)this.environment.getProperty("encrypt.privateKey", String.class);
        Boolean debug = (Boolean)this.environment.getProperty("encrypt.debug", Boolean.TYPE);
        if (debug != null && debug.booleanValue()) {
            return;
        }
        if (type == null) {
            throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u52a0\u5bc6\u7c7b\u578b(No encryption type is defined)");
        }
        switch (type) {
            case BASE64: {
                bean.setBeanClass(Base64EncryptHandler.class);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case AES: {
                if (secret == null || "".equals(secret.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u79d8\u94a5(No secret key is defined)");
                }
                bean.setBeanClass(AesEncryptHandler.class);
                bean.getPropertyValues().add("secret", (Object)secret);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case RSA: {
                if (publicKey == null || "".equals(publicKey.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u516c\u94a5(No publicKey is defined)");
                }
                if (privateKey == null || "".equals(privateKey.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u79c1\u94a5(No privateKey is defined)");
                }
                bean.setBeanClass(RsaEncryptHandler.class);
                bean.getPropertyValues().add("publicKey", (Object)publicKey);
                bean.getPropertyValues().add("privateKey", (Object)privateKey);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case CUSTOM: {
                try {
                    beanFactory.getBean(EncryptHandler.class);
                    break;
                }
                catch (Exception e) {
                    throw new EncryptException("\u6ca1\u6709\u81ea\u5b9a\u4e49\u52a0\u5bc6\u5904\u7406\u5668(No custom encryption processor)");
                }
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptConfiguration)) {
            return false;
        }
        EncryptConfiguration other = (EncryptConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "EncryptConfiguration(applicationContext=" + this.getApplicationContext() + ", environment=" + this.getEnvironment() + ")";
    }
}

