/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.config;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.mate.core.encrypt.config.EncryptRequestWrapper;
import vip.mate.core.encrypt.config.EncryptResponseWrapper;
import vip.mate.core.encrypt.handler.EncryptHandler;
import vip.mate.core.encrypt.handler.InitHandler;

public class EncryptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(EncryptFilter.class);
    private EncryptHandler encryptHandler;
    private static AtomicBoolean isEncryptAnnotation = new AtomicBoolean(false);
    private static final Set<String> encryptCacheUri = new HashSet<String>();

    public EncryptFilter(EncryptHandler encryptHandler) {
        this.encryptHandler = encryptHandler;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (isEncryptAnnotation.get()) {
            if (this.checkUri(((HttpServletRequest)servletRequest).getRequestURI())) {
                this.chain(servletRequest, servletResponse, filterChain);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String contentType = request.getContentType();
            if (request.getRequestURI().startsWith("/actuator") || contentType == null || !contentType.toLowerCase().equals("application/json")) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                this.chain(servletRequest, servletResponse, filterChain);
            }
        }
    }

    private void chain(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        EncryptRequestWrapper request = new EncryptRequestWrapper((HttpServletRequest)servletRequest, this.encryptHandler);
        EncryptResponseWrapper response = new EncryptResponseWrapper((HttpServletResponse)servletResponse);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        byte[] responseData = response.getResponseData();
        if (responseData.length == 0) {
            return;
        }
        log.info("\u63a5\u6536\u7684\u62a5\u6587\uff1a" + new String(responseData));
        byte[] encryptByte = this.encryptHandler.encode(URLEncoder.encode(new String(responseData), "UTF-8").getBytes());
        log.info("\u52a0\u5bc6\u540e\u7684\u62a5\u6587\uff1a" + new String(encryptByte));
        servletResponse.setContentLength(-1);
        servletResponse.setContentType("application/json;charset=UTF-8");
        ServletOutputStream outputStream = servletResponse.getOutputStream();
        log.info("outputStream: " + outputStream.toString());
        outputStream.write(encryptByte);
        outputStream.flush();
    }

    private boolean checkUri(String uri) {
        if ((uri = uri.replaceAll("//+", "/")).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return encryptCacheUri.contains(uri);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        InitHandler.handler(filterConfig, encryptCacheUri, isEncryptAnnotation);
    }

    public void destroy() {
    }
}

