/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.mate.core.encrypt.handler.EncryptHandler;

public class EncryptRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(EncryptRequestWrapper.class);
    private byte[] body;
    private EncryptHandler encryptHandler;

    public EncryptRequestWrapper(HttpServletRequest request, EncryptHandler encryptHandler) throws IOException, ServletException {
        super(request);
        this.encryptHandler = encryptHandler;
        if (!request.getContentType().toLowerCase().equals("application/json") && !request.getContentType().toLowerCase().equals("application/json;charset=UTF-8".toLowerCase())) {
            throw new ServletException("contentType error");
        }
        ServletInputStream inputStream = request.getInputStream();
        int contentLength = Integer.parseInt(request.getHeader("Content-Length"));
        byte[] bytes = new byte[contentLength];
        for (int readCount = 0; readCount < contentLength; readCount += inputStream.read(bytes, readCount, contentLength - readCount)) {
        }
        this.body = bytes;
    }

    public ServletInputStream getInputStream() throws IOException {
        log.info("\u63a5\u6536\u5230\u7684\u8bf7\u6c42\u5bc6\u6587\uff1a" + new String(this.body));
        byte[] decode = this.encryptHandler.decode(this.body);
        String urlDecodeStr = URLDecoder.decode(new String(decode), "UTF-8");
        log.info("\u89e3\u5bc6\u540e\u7684\u62a5\u6587\uff1a" + urlDecodeStr);
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(urlDecodeStr.getBytes());
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }
}

