/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.config;

import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import vip.mate.core.encrypt.annotation.SignEncrypt;
import vip.mate.core.encrypt.handler.SignEncryptHandler;
import vip.mate.core.encrypt.handler.impl.SignEncryptHandlerImpl;
import vip.mate.core.encrypt.interceptor.SignEncryptInterceptor;

@ConditionalOnExpression(value="environment.getProperty('encrypt.signSecret')!=null && environment.getProperty('encrypt.signSecret').trim()!=''")
public class SignEncryptConfiguration {
    @Autowired
    private SignEncryptHandler signEncryptHandler;

    @ConditionalOnMissingBean(value={SignEncryptHandler.class})
    @Bean
    public SignEncryptHandler sortSignEncryptHandlerDefult() {
        return new SignEncryptHandlerImpl();
    }

    @Bean
    public DefaultPointcutAdvisor sortSignEncryptAdvisor(@Value(value="${encrypt.signSecret}") String sortSignSecret) {
        SignEncryptInterceptor interceptor = new SignEncryptInterceptor(sortSignSecret, this.signEncryptHandler);
        AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(null, SignEncrypt.class);
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }
}

