/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.config;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import vip.mate.core.encrypt.config.EncryptFilter;
import vip.mate.core.encrypt.handler.EncryptHandler;

@Configuration
public class WebConfiguration {
    @Autowired(required=false)
    private final EncryptHandler encryptHandler;
    Environment environment;

    @Bean
    @Conditional(value={DefaultCondition.class})
    public FilterRegistrationBean filterRegistrationBean() {
        Integer order = (Integer)this.environment.getProperty("encrypt.order", Integer.class);
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new EncryptFilter(this.encryptHandler));
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setName("encryptFilter");
        bean.setOrder(order == null ? 0 : order);
        return bean;
    }

    public WebConfiguration(EncryptHandler encryptHandler, Environment environment) {
        this.encryptHandler = encryptHandler;
        this.environment = environment;
    }

    static class DefaultCondition
    implements Condition {
        DefaultCondition() {
        }

        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            Environment environment = conditionContext.getEnvironment();
            Boolean debug = (Boolean)environment.getProperty("encrypt.debug", Boolean.class);
            return debug == null || debug == false;
        }
    }
}

