/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.encrypt.wrapper;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import vip.mate.core.encrypt.handler.EncryptHandler;
import vip.mate.core.encrypt.wrapper.CacheRequestWrapper;
import vip.mate.core.encrypt.wrapper.EncryptBodyRequestWrapper;

public class EncryptRequestWrapperFactory {
    public static HttpServletRequest getWrapper(HttpServletRequest request, EncryptHandler encryptService) throws IOException, ServletException {
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        if (contentType == null || contentLength == 0) {
            return request;
        }
        if (EncryptRequestWrapperFactory.contentIsJson(contentType = contentType.toLowerCase())) {
            return new EncryptBodyRequestWrapper(request, encryptService);
        }
        return request;
    }

    public static HttpServletRequest getCacheWarpper(HttpServletRequest request) throws IOException, ServletException {
        if (!"POST".equalsIgnoreCase(request.getMethod()) || !EncryptRequestWrapperFactory.contentIsJson(request.getContentType())) {
            return request;
        }
        return new CacheRequestWrapper(request);
    }

    public static boolean contentIsJson(String contentType) {
        return contentType.equals("application/json".toLowerCase()) || contentType.equals("application/json;charset=UTF-8".toLowerCase());
    }
}

