/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.jetcache.config;

import com.alicp.jetcache.anno.config.EnableCreateCacheAnnotation;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.SpringConfigProvider;
import com.alicp.jetcache.embedded.EmbeddedCacheBuilder;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.alicp.jetcache.redis.springdata.RedisSpringDataCacheBuilder;
import com.alicp.jetcache.support.FastjsonKeyConvertor;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.JavaValueEncoder;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import java.util.HashMap;
import java.util.function.Function;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import vip.mate.core.common.factory.YamlPropertySourceFactory;

@Configuration
@EnableMethodCache(basePackages={"vip.mate"})
@EnableCreateCacheAnnotation
@PropertySource(factory=YamlPropertySourceFactory.class, value={"classpath:mate-jetcache.yml"})
public class JetCacheConfiguration {
    @Bean
    public RedisClient redisClient() {
        RedisClient client = RedisClient.create((String)"redis://127.0.0.1");
        client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
        return client;
    }

    @Bean
    public SpringConfigProvider springConfigProvider() {
        return new SpringConfigProvider();
    }

    @Bean
    public GlobalCacheConfig config(SpringConfigProvider configProvider, RedisClient redisClient) {
        HashMap<String, EmbeddedCacheBuilder> localBuilders = new HashMap<String, EmbeddedCacheBuilder>();
        EmbeddedCacheBuilder localBuilder = (EmbeddedCacheBuilder)LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder().keyConvertor((Function)FastjsonKeyConvertor.INSTANCE);
        localBuilders.put("default", localBuilder);
        HashMap<String, RedisSpringDataCacheBuilder> remoteBuilders = new HashMap<String, RedisSpringDataCacheBuilder>(6);
        RedisSpringDataCacheBuilder redisSpringDataCacheBuilder = (RedisSpringDataCacheBuilder)((RedisSpringDataCacheBuilder.RedisSpringDataCacheBuilderImpl)((RedisSpringDataCacheBuilder.RedisSpringDataCacheBuilderImpl)RedisSpringDataCacheBuilder.createBuilder().keyConvertor((Function)FastjsonKeyConvertor.INSTANCE)).valueEncoder((Function)JavaValueEncoder.INSTANCE)).valueDecoder((Function)JavaValueDecoder.INSTANCE);
        remoteBuilders.put("default", redisSpringDataCacheBuilder);
        GlobalCacheConfig globalCacheConfig = new GlobalCacheConfig();
        globalCacheConfig.setLocalCacheBuilders(localBuilders);
        globalCacheConfig.setRemoteCacheBuilders(remoteBuilders);
        globalCacheConfig.setStatIntervalMinutes(15);
        globalCacheConfig.setAreaInCacheName(false);
        return globalCacheConfig;
    }
}

