/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.security.handle;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import vip.mate.core.common.api.IResultCode;
import vip.mate.core.common.api.Result;
import vip.mate.core.common.api.ResultCode;
import vip.mate.core.common.util.ResponseUtil;

public class MateAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(MateAuthenticationFailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        Result result = null;
        String username = request.getParameter("username");
        if (exception instanceof AccountExpiredException) {
            log.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u8d26\u53f7\u8fc7\u671f", (Object)username);
            result = Result.fail((IResultCode)ResultCode.USER_ACCOUNT_EXPIRED);
        } else if (exception instanceof BadCredentialsException) {
            log.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u5bc6\u7801\u9519\u8bef", (Object)username);
            result = Result.fail((IResultCode)ResultCode.USER_PASSWORD_ERROR);
        } else if (exception instanceof CredentialsExpiredException) {
            log.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u5bc6\u7801\u8fc7\u671f", (Object)username);
            result = Result.fail((IResultCode)ResultCode.USER_PASSWORD_EXPIRED);
        } else if (exception instanceof DisabledException) {
            log.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u88ab\u7981\u7528", (Object)username);
            result = Result.fail((IResultCode)ResultCode.USER_DISABLED);
        } else if (exception instanceof LockedException) {
            log.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u88ab\u9501\u5b9a", (Object)username);
            result = Result.fail((IResultCode)ResultCode.USER_LOCKED);
        } else if (exception instanceof InternalAuthenticationServiceException) {
            log.error(String.format("[\u767b\u5f55\u5931\u8d25] - [%s]\u5185\u90e8\u9519\u8bef", username));
            result = Result.fail((IResultCode)ResultCode.USER_LOGIN_FAIL);
        } else {
            log.error(String.format("[\u767b\u5f55\u5931\u8d25] - [%s]\u5176\u4ed6\u9519\u8bef", username), (Throwable)exception);
            result = Result.fail((IResultCode)ResultCode.USER_LOGIN_FAIL);
        }
        ResponseUtil.responseWriter((HttpServletResponse)response, (String)"UTF-8", (int)HttpStatus.UNAUTHORIZED.value(), (Object)result);
    }
}

