/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.security.handle;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class MateAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(MateAuthenticationSuccessHandler.class);
    @Autowired
    @NonNull
    private ClientDetailsService clientDetailsService;
    @Autowired
    @NonNull
    private PasswordEncoder passwordEncoder;
    @Lazy
    @Autowired
    @NonNull
    private AuthorizationServerTokenServices authorizationServerTokenServices;
    @Autowired
    @NonNull
    private ObjectMapper objectMapper;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        log.info("Login succeed\uff01");
        String header = request.getHeader("Authorization");
        if (header == null || !header.toLowerCase().startsWith("basic ")) {
            throw new UnapprovedClientAuthenticationException("\u8bf7\u6c42\u5934\u4e2d\u65e0\u5ba2\u6237\u7aef\u4fe1\u606f");
        }
        String[] client = this.extractAndDecodeHeader(header);
        if (client.length != 2) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        String clientId = client[0];
        String clientSecret = client[1];
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        if (clientDetails == null) {
            throw new UnapprovedClientAuthenticationException("\u5ba2\u6237\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + clientId);
        }
        if (!this.passwordEncoder.matches((CharSequence)clientSecret, clientDetails.getClientSecret())) {
            throw new UnapprovedClientAuthenticationException("\u5ba2\u6237\u7aef\u5bc6\u94a5\u4e0d\u5339\u914d" + clientSecret);
        }
        TokenRequest tokenRequest = new TokenRequest(new HashMap(0), clientId, (Collection)clientDetails.getScope(), "custom");
        OAuth2Request oAuth2Request = tokenRequest.createOAuth2Request(clientDetails);
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(oAuth2Request, authentication);
        OAuth2AccessToken accessToken = this.authorizationServerTokenServices.createAccessToken(oAuth2Authentication);
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)accessToken));
    }

    private String[] extractAndDecodeHeader(String header) {
        byte[] decoded;
        byte[] base64Token = header.substring(6).getBytes(StandardCharsets.UTF_8);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delimiter = token.indexOf(":");
        if (delimiter == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delimiter), token.substring(delimiter + 1)};
    }
}

