/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.security.service;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Service(value="mt")
public class PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionService.class);

    public boolean hasPerm(String ... permissions) {
        if (ArrayUtils.isEmpty((Object[])permissions)) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Collection authorities = authentication.getAuthorities();
        return authorities.stream().map(GrantedAuthority::getAuthority).filter(StringUtils::hasText).anyMatch(x -> PatternMatchUtils.simpleMatch((String[])permissions, (String)x));
    }
}

