/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.sms.core;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Random;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.mate.core.sms.core.SmsTemplate;
import vip.mate.core.sms.props.SmsProperties;

public class AliSmsTemplate
implements SmsTemplate {
    private static final Logger log = LoggerFactory.getLogger(AliSmsTemplate.class);
    private final SmsProperties smsProperties;

    public IAcsClient getDefaultAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.smsProperties.getRegionId(), (String)this.smsProperties.getAccessKey(), (String)this.smsProperties.getSecretKey());
        DefaultProfile.addEndpoint((String)this.smsProperties.getRegionId(), (String)this.smsProperties.getProduct(), (String)this.smsProperties.getDomain());
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        return new DefaultAcsClient((IClientProfile)profile);
    }

    private CommonRequest request() {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(this.smsProperties.getDomain());
        request.setSysVersion(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", this.smsProperties.getRegionId());
        return request;
    }

    @Override
    public boolean sendSms(@NonNull String phoneNumber, @NonNull String signName, @NonNull String templateCode, @NonNull String templateParam) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        if (signName == null) {
            throw new NullPointerException("signName is marked non-null but is null");
        }
        if (templateCode == null) {
            throw new NullPointerException("templateCode is marked non-null but is null");
        }
        if (templateParam == null) {
            throw new NullPointerException("templateParam is marked non-null but is null");
        }
        CommonRequest request = this.request();
        request.putQueryParameter("PhoneNumbers", phoneNumber);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", templateParam);
        try {
            CommonResponse response = this.getDefaultAcsClient().getCommonResponse(request);
            log.info(response.getData());
            return true;
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\uff1a{}", (Throwable)e);
            return false;
        }
    }

    @Override
    public String sendRandCode(int digits) {
        StringBuilder sBuilder = new StringBuilder();
        Random rd = new Random(LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
        for (int i = 0; i < digits; ++i) {
            sBuilder.append(rd.nextInt(9));
        }
        return sBuilder.toString();
    }

    public AliSmsTemplate(SmsProperties smsProperties) {
        this.smsProperties = smsProperties;
    }
}

