/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.adapter

import android.view.View
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.RecyclerView

abstract class BaseAdapter<T, B : ViewDataBinding>(val itemClick: ((T, View, Int) -> Unit)? = null) : RecyclerView.Adapter<BaseViewHolder<B>>() {
    val data = mutableListOf<T>()
    var selectedPosition = -1

    override fun getItemCount(): Int = data.size

    fun display(list: List<T>) {
        data.clear()
        data.addAll(list)
        notifyDataSetChanged()
    }

    fun addAll(list: List<T>) {
        val beforeSize = data.size
        if (data.addAll(list)) {
            notifyItemRangeInserted(beforeSize, list.size)
        }
    }

    fun addFirstMessage(list: List<T>) {
        data.clear()
        data.addAll(list)
        notifyDataSetChanged()
    }

    fun addNewListMessage(list: List<T>) {
        if (data.addAll(0, list)) {
            notifyItemRangeInserted(data.size - list.size, data.size)
        }
    }

    fun addAll(index: Int, list: List<T>) {
        if (data.addAll(index, list)) {
            notifyItemRangeInserted(index, list.size)
        }
    }

    fun clear() {
        if (data.isNotEmpty()) {
            data.clear()
            notifyDataSetChanged()
        }
    }

    fun add(element: T) {
        val beforeSize = data.size
        if (data.add(element)) {
            notifyItemInserted(beforeSize)
        }
    }

    fun remove(element: T) {
        val index = data.indexOf(element)
        if (data.remove(element)) {
            notifyItemRemoved(index)
        }
    }

    fun add(index: Int, element: T) {
        val size = itemCount
        require(index < size)
        data.add(index, element)
        if (data.size > size) {
            notifyItemInserted(index)
        }
    }

    fun removeAll(list: List<T>) {
        val indexes: MutableList<Int> = ArrayList()
        var index: Int
        for (item in list) {
            index = data.indexOf(item)
            if (index >= 0) {
                indexes.add(index)
            }
        }
        if (data.removeAll(list)) {
            for (k in indexes.indices) {
                notifyItemRemoved(indexes[k])
            }
        }
    }

    fun getAll(): List<T> = data
}
