/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.adapter

import android.view.View
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.AdapterListUpdateCallback
import androidx.recyclerview.widget.AsyncDifferConfig
import androidx.recyclerview.widget.AsyncListDiffer
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView

/**
Created by vantoan on 20/Jan/2021
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

abstract class BaseListAdapter<T, B : ViewDataBinding>(
    val itemClick: ((T, View, Int) -> Unit)? = null,
    diffCallback: DiffUtil.ItemCallback<T>
) :
    RecyclerView.Adapter<BaseViewHolder<B>>() {
    private val asyncListDiffer: AsyncListDiffer<T> by lazy {
        AsyncListDiffer(
            AdapterListUpdateCallback(this),
            AsyncDifferConfig.Builder(diffCallback).build()
        )
    }

    val getData: ArrayList<T>
        get() = ArrayList(asyncListDiffer.currentList)

    override fun getItemCount(): Int = getData.size

    fun display(newList: List<T>) = asyncListDiffer.submitList(newList.toMutableList())

    fun getItem(position: Int): T? {
        return if (getData.isNotEmpty()) {
            getData[position]
        } else {
            null
        }
    }

    fun add(element: T) {
        val beforeSize = getData.size
        if (getData.add(element)) {
            notifyItemInserted(beforeSize)
        }
    }

    fun remove(element: T) {
        val index = getData.indexOf(element)
        if (getData.remove(element)) {
            notifyItemRemoved(index)
        }
    }
}
