/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.binding.clickDebounce

/**
Created by vantoan on 20/Jan/2021
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

abstract class BaseListSimpleAdapter<T, B : ViewDataBinding>(
    itemClick: ((T, View, Int) -> Unit)? = null,
    diff: DiffUtil.ItemCallback<T>
) : BaseListAdapter<T, B>(itemClick, diff) {
    private var layoutInflater: LayoutInflater? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<B> {
        if (layoutInflater == null) layoutInflater = LayoutInflater.from(parent.context)
        val binding: B = DataBindingUtil.inflate(layoutInflater!!, layout, parent, false)
        return BaseViewHolder(binding)
    }

    override fun onBindViewHolder(holder: BaseViewHolder<B>, position: Int) {
        getItem(position)?.let { item ->
            with(holder) {
                itemView.clickDebounce {
                    itemClick?.invoke(item, itemView, position)
                }
                bind(item, this, position)
                binding.executePendingBindings()
            }
        }
    }

    abstract fun bind(item: T, holder: BaseViewHolder<B>, position: Int)
    abstract val layout: Int
}
