/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.base.chat.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil

/**
Created by vantoan on 20/Jan/2021
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

abstract class BaseMultiTypeListSimpleAdapter<T, B : ViewDataBinding>(
    itemClick: ((T, View, Int) -> Unit)? = null,
    diff: DiffUtil.ItemCallback<T>
) : BaseListAdapter<T, B>(itemClick, diff) {

    fun inflateView(parent: ViewGroup, layoutRes: Int): ViewDataBinding {
        return DataBindingUtil.inflate(
            LayoutInflater.from(parent.context),
            layoutRes,
            parent,
            false
        )
    }

    override fun getItemViewType(position: Int) = bindMultiType(position)

    override fun getItemCount(): Int = getData.size

    protected abstract fun bindMultiType(position: Int): Int
}
