package com.netacom.base.chat.adapter

import androidx.recyclerview.widget.RecyclerView
import com.netacom.base.chat.define.ConfigDef
import com.netacom.base.chat.logger.Logger

class GroupViewPagination(
    recyclerView: RecyclerView,
    private val loadMore: (Int) -> Unit
) : RecyclerView.OnScrollListener() {

    private var currentPage = 0

    init {
        recyclerView.addOnScrollListener(this)
    }

    private val pageSize = ConfigDef.PAGE_SIZE_GROUP_GET

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (!recyclerView.canScrollVertically(1) && newState == RecyclerView.SCROLL_STATE_IDLE) {
            val layoutManager = recyclerView.layoutManager ?: return
            val totalItemCount = layoutManager.itemCount
            currentPage = if (totalItemCount % pageSize == 0) totalItemCount / pageSize - 1 else totalItemCount / pageSize
            Logger.d("____end refactor @pageSize = $currentPage")
            if (currentPage >= 0) {
                loadMore(currentPage)
            }
        }
    }
}
