package com.netacom.base.chat.adapter

import androidx.recyclerview.widget.RecyclerView
import com.netacom.base.chat.define.ConfigDef

class MediaViewPagination(
    recyclerView: RecyclerView,
    private val loadMore: () -> Unit
) : RecyclerView.OnScrollListener() {

    init {
        recyclerView.addOnScrollListener(this)
    }

    private val pageSize = ConfigDef.PAGE_SIZE_MEDIA_GET

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (!recyclerView.canScrollVertically(1) && newState == RecyclerView.SCROLL_STATE_IDLE) {
            val layoutManager = recyclerView.layoutManager ?: return
            val totalItemCount = layoutManager.itemCount
            if (totalItemCount > 0 && totalItemCount % pageSize == 0) {
                loadMore()
            }
        }
    }
}
