/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.adapter

import androidx.recyclerview.widget.RecyclerView
import com.netacom.base.chat.define.ConfigDef

@Suppress("SpellCheckingInspection", "MemberVisibilityCanBePrivate", "unused")
class RecyclerViewPaginator(
    private val recyclerView: RecyclerView,
    private val isLoading: () -> Boolean,
    private val isMessage: Boolean = false,
    private val loadMore: (Int) -> Unit,
    private val onLast: () -> Boolean = { true }
) : RecyclerView.OnScrollListener() {

    private val threshold = ConfigDef.THRESHOLD
    private var currentPage = 0

    var endWithAuto = false
    val pageSize = ConfigDef.PAGE_SIZE_MESSAGE_GET

    init {
        recyclerView.addOnScrollListener(this)
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (!recyclerView.canScrollVertically(-1) && newState == RecyclerView.SCROLL_STATE_IDLE && !isLoading()) {
            val layoutManager = recyclerView.layoutManager ?: return
            val totalItemCount = layoutManager.itemCount
            currentPage = if (totalItemCount % pageSize == 0) totalItemCount / pageSize - 1 else totalItemCount / pageSize
            if (currentPage >= 0) {
                loadMore(currentPage)
            }
        }
    }
}
