package com.netacom.base.chat.android_utils

import android.Manifest.permission.ACCESS_BACKGROUND_LOCATION
import android.Manifest.permission.ACCESS_COARSE_LOCATION
import android.Manifest.permission.ACCESS_FINE_LOCATION
import android.Manifest.permission.CAMERA
import android.Manifest.permission.GET_ACCOUNTS
import android.Manifest.permission.READ_CONTACTS
import android.Manifest.permission.READ_EXTERNAL_STORAGE
import android.Manifest.permission.RECORD_AUDIO
import android.Manifest.permission.VIBRATE
import android.Manifest.permission.WRITE_CONTACTS
import android.Manifest.permission.WRITE_EXTERNAL_STORAGE
import android.annotation.SuppressLint
import com.netacom.base.chat.logger.Logger

sealed class Permission(vararg val permissions: String) {
    // Individual permissions
    object Camera : Permission(CAMERA)
    object Contact : Permission(READ_CONTACTS, WRITE_CONTACTS, GET_ACCOUNTS)
    object Micro : Permission(RECORD_AUDIO)
    object Vibrate : Permission(VIBRATE)
    // Grouped permissions
    @SuppressLint("InlinedApi")
    object Location : Permission(ACCESS_FINE_LOCATION, ACCESS_COARSE_LOCATION, ACCESS_BACKGROUND_LOCATION)
    object Storage : Permission(WRITE_EXTERNAL_STORAGE, READ_EXTERNAL_STORAGE)

    companion object {
        fun from(permission: String) = when (permission) {
            ACCESS_FINE_LOCATION, ACCESS_COARSE_LOCATION, ACCESS_BACKGROUND_LOCATION -> Location
            WRITE_EXTERNAL_STORAGE, READ_EXTERNAL_STORAGE -> Storage
            CAMERA -> Camera
            RECORD_AUDIO -> Micro
            VIBRATE -> Vibrate
            READ_CONTACTS, WRITE_CONTACTS, GET_ACCOUNTS -> Contact
            else -> {
                Logger.e("Unknown permission: $permission")
                Storage
            }
        }
    }
}
