package com.netacom.base.chat.android_utils

import android.content.res.Resources
import android.graphics.Typeface
import android.text.Html.fromHtml
import android.text.Spannable
import android.text.SpannableString
import android.text.style.StyleSpan
import androidx.annotation.StringRes
import androidx.core.text.HtmlCompat
import java.util.IllegalFormatException

object StringUtils {
    private fun format(str: String?, vararg args: Any?): String? {
        var text = str
        if (text != null) {
            if (args.isNotEmpty()) {
                try {
                    text = String.format(str!!, *args)
                } catch (e: IllegalFormatException) {
                    e.printStackTrace()
                }
            }
        }
        return text
    }

    fun getString(@StringRes id: Int): String {
        return try {
            Utils.getApp().resources.getString(id)
        } catch (e: Resources.NotFoundException) {
            e.printStackTrace()
            id.toString()
        }
    }

    fun getString(@StringRes id: Int, vararg formatArgs: Any?): String {
        return try {
            format(Utils.getApp().resources.getString(id), *formatArgs) ?: ""
        } catch (e: Resources.NotFoundException) {
            e.printStackTrace()
            id.toString()
        }
    }

    fun isSpace(s: String?): Boolean {
        if (s == null) return true
        var i = 0
        val len = s.length
        while (i < len) {
            if (!Character.isWhitespace(s[i])) {
                return false
            }
            ++i
        }
        return true
    }

    fun spanText(senderName: String, content: String): Spannable {
        val span = SpannableString("$senderName$content")

        if (senderName.isNotEmpty()) {
            span.setSpan(
                StyleSpan(Typeface.BOLD),
                0,
                senderName.length,
                Spannable.SPAN_EXCLUSIVE_INCLUSIVE
            )
        }

        return span
    }

    @Suppress("DEPRECATION")
    fun fromHtmlText(code: String): String {
        return if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            fromHtml(code, HtmlCompat.FROM_HTML_MODE_LEGACY).toString()
        } else {
            fromHtml(code).toString()
        }
    }

    fun handleSpecialChar(text: String?, isTextType: Boolean = false): String? {
        text ?: return null
        return when {
            text.isBlank() -> ""
            isTextType -> {
                text.replace("\\", "\\\\")
                    .replace("\"", "\\\"")
                    .replace("\r", "\\r")
                    .replace("\n", "\\n")
                    .trim()
            }
            else -> {
                text.replace("\\", "\\\\")
                    .replace("\"", "\\\"")
                    .trim()
            }
        }
    }
}
