package com.netacom.base.chat.android_utils

import android.Manifest.permission
import android.app.Activity
import android.app.Application
import android.app.Notification
import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.Bitmap.CompressFormat
import android.graphics.drawable.Drawable
import android.net.Uri
import android.os.Build
import android.os.Parcelable
import android.text.TextUtils
import android.view.View
import androidx.annotation.RequiresPermission
import androidx.core.app.NotificationCompat
import com.netacom.base.chat.android_utils.ActivityUtils.Companion.launcherActivity
import com.netacom.base.chat.android_utils.NotificationUtils.ChannelConfig
import com.netacom.base.chat.android_utils.Utils.OnAppStatusChangedListener
import org.json.JSONArray
import org.json.JSONObject
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.InputStream
import java.io.Serializable

/**
 * <pre>
 * author: blankj
 * blog  : http://blankj.com
 * time  : 2020/03/19
 * desc  :
</pre> *
 */
internal object UtilsBridge {
    @JvmStatic
    fun init(app: Application?) {
        UtilsActivityLifecycleImpl.INSTANCE.init(app)
    }

    @JvmStatic
    fun unInit(app: Application?) {
        UtilsActivityLifecycleImpl.INSTANCE.unInit(app)
    }

    @JvmStatic
    fun preLoad() {
        preLoad(AdaptScreenUtils.getPreLoadRunnable())
    }

    // /////////////////////////////////////////////////////////////////////////
    // UtilsActivityLifecycleImpl
    // /////////////////////////////////////////////////////////////////////////
    val topActivity: Activity
        get() = UtilsActivityLifecycleImpl.INSTANCE.topActivity

    @JvmStatic
    fun addOnAppStatusChangedListener(listener: OnAppStatusChangedListener?) {
        UtilsActivityLifecycleImpl.INSTANCE.addOnAppStatusChangedListener(listener)
    }

    @JvmStatic
    fun removeOnAppStatusChangedListener(listener: OnAppStatusChangedListener?) {
        UtilsActivityLifecycleImpl.INSTANCE.removeOnAppStatusChangedListener(listener)
    }

    fun addActivityLifecycleCallbacks(callbacks: Utils.ActivityLifecycleCallbacks?) {
        UtilsActivityLifecycleImpl.INSTANCE.addActivityLifecycleCallbacks(callbacks)
    }

    fun removeActivityLifecycleCallbacks(callbacks: Utils.ActivityLifecycleCallbacks?) {
        UtilsActivityLifecycleImpl.INSTANCE.removeActivityLifecycleCallbacks(callbacks)
    }

    fun addActivityLifecycleCallbacks(
        activity: Activity?,
        callbacks: Utils.ActivityLifecycleCallbacks?
    ) {
        UtilsActivityLifecycleImpl.INSTANCE.addActivityLifecycleCallbacks(activity, callbacks)
    }

    fun removeActivityLifecycleCallbacks(activity: Activity?) {
        UtilsActivityLifecycleImpl.INSTANCE.removeActivityLifecycleCallbacks(activity)
    }

    fun removeActivityLifecycleCallbacks(
        activity: Activity?,
        callbacks: Utils.ActivityLifecycleCallbacks?
    ) {
        UtilsActivityLifecycleImpl.INSTANCE.removeActivityLifecycleCallbacks(activity, callbacks)
    }

    val activityList: List<Activity>
        get() = UtilsActivityLifecycleImpl.INSTANCE.activityList

    @JvmStatic
    val applicationByReflect: Application
        get() = UtilsActivityLifecycleImpl.INSTANCE.applicationByReflect

    @JvmStatic
    val isAppForeground: Boolean
        get() = UtilsActivityLifecycleImpl.INSTANCE.isAppForeground

    // /////////////////////////////////////////////////////////////////////////
    // ActivityUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun isActivityAlive(activity: Activity?): Boolean {
        return ActivityUtils.isActivityAlive(activity)
    }

    @JvmStatic
    fun getLauncherActivity(pkg: String?): String {
        return launcherActivity
    }

    @JvmStatic
    fun getActivityByContext(context: Context?): Activity? {
        return ActivityUtils.getActivityByContext(context!!)
    }

    @JvmStatic
    fun finishAllActivities() {
        ActivityUtils.finishAllActivities()
    }

    // /////////////////////////////////////////////////////////////////////////
    // AppUtils
    // /////////////////////////////////////////////////////////////////////////
    fun isAppRunning(pkgName: String): Boolean {
        return AppUtils.isAppRunning(pkgName)
    }

    fun isAppInstalled(pkgName: String?): Boolean {
        return AppUtils.isAppInstalled(pkgName)
    }

    val isAppDebug: Boolean
        get() = AppUtils.isAppDebug()

    fun relaunchApp() {
        AppUtils.relaunchApp()
    }

    // /////////////////////////////////////////////////////////////////////////
    // BarUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    val statusBarHeight: Int
        get() = BarUtils.getStatusBarHeight()

    @JvmStatic
    val navBarHeight: Int
        get() = BarUtils.getNavBarHeight()

    // /////////////////////////////////////////////////////////////////////////
    // ConvertUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun bytes2HexString(bytes: ByteArray?): String {
        return ConvertUtils.bytes2HexString(bytes)
    }

    fun hexString2Bytes(hexString: String?): ByteArray {
        return ConvertUtils.hexString2Bytes(hexString)
    }

    fun string2Bytes(string: String?): ByteArray {
        return ConvertUtils.string2Bytes(string)
    }

    fun bytes2String(bytes: ByteArray?): String {
        return ConvertUtils.bytes2String(bytes)
    }

    fun jsonObject2Bytes(jsonObject: JSONObject?): ByteArray {
        return ConvertUtils.jsonObject2Bytes(jsonObject)
    }

    fun bytes2JSONObject(bytes: ByteArray?): JSONObject {
        return ConvertUtils.bytes2JSONObject(bytes)
    }

    fun jsonArray2Bytes(jsonArray: JSONArray?): ByteArray {
        return ConvertUtils.jsonArray2Bytes(jsonArray)
    }

    fun bytes2JSONArray(bytes: ByteArray?): JSONArray {
        return ConvertUtils.bytes2JSONArray(bytes)
    }

    fun parcelable2Bytes(parcelable: Parcelable?): ByteArray {
        return ConvertUtils.parcelable2Bytes(parcelable)
    }

    fun <T> bytes2Parcelable(
        bytes: ByteArray?,
        creator: Parcelable.Creator<T>?
    ): T {
        return ConvertUtils.bytes2Parcelable(bytes, creator)
    }

    fun serializable2Bytes(serializable: Serializable?): ByteArray {
        return ConvertUtils.serializable2Bytes(serializable)
    }

    fun bytes2Object(bytes: ByteArray?): Any {
        return ConvertUtils.bytes2Object(bytes)
    }

    @JvmStatic
    fun byte2FitMemorySize(byteSize: Long): String {
        return ConvertUtils.byte2FitMemorySize(byteSize)
    }

    @JvmStatic
    fun inputStream2Bytes(`is`: InputStream?): ByteArray {
        return ConvertUtils.inputStream2Bytes(`is`)
    }

    fun input2OutputStream(`is`: InputStream?): ByteArrayOutputStream {
        return ConvertUtils.input2OutputStream(`is`)
    }

    fun inputStream2Lines(`is`: InputStream?, charsetName: String?): List<String> {
        return ConvertUtils.inputStream2Lines(`is`, charsetName)
    }

    // /////////////////////////////////////////////////////////////////////////
    // DebouncingUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun isValid(view: View, duration: Long): Boolean {
        return DebouncingUtils.isValid(view, duration)
    }

    // /////////////////////////////////////////////////////////////////////////
    // UriUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun file2Uri(file: File?): Uri {
        return UriUtils.file2Uri(file)
    }

    @JvmStatic
    fun uri2File(uri: Uri?): File {
        return UriUtils.uri2File(uri)
    }

    // /////////////////////////////////////////////////////////////////////////
    // FileIOUtils
    // /////////////////////////////////////////////////////////////////////////
    fun writeFileFromBytes(
        file: File?,
        bytes: ByteArray?
    ): Boolean {
        return FileIOUtils.writeFileFromBytesByChannel(file, bytes, true)
    }

    fun readFile2Bytes(file: File?): ByteArray {
        return FileIOUtils.readFile2BytesByChannel(file)
    }

    @JvmStatic
    fun writeFileFromString(filePath: String?, content: String?, append: Boolean): Boolean {
        return FileIOUtils.writeFileFromString(filePath, content, append)
    }

    @JvmStatic
    fun writeFileFromIS(filePath: String?, `is`: InputStream?): Boolean {
        return FileIOUtils.writeFileFromIS(filePath, `is`)
    }

    // /////////////////////////////////////////////////////////////////////////
    // FileUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun isFileExists(file: File?): Boolean {
        return FileUtils.isFileExists(file)
    }

    @JvmStatic
    fun getFileByPath(filePath: String?): File {
        return FileUtils.getFileByPath(filePath)
    }

    fun deleteAllInDir(dir: File?): Boolean {
        return FileUtils.deleteAllInDir(dir)
    }

    @JvmStatic
    fun createOrExistsFile(file: File?): Boolean {
        return FileUtils.createOrExistsFile(file)
    }

    @JvmStatic
    fun createOrExistsDir(file: File?): Boolean {
        return FileUtils.createOrExistsDir(file)
    }

    @JvmStatic
    fun createFileByDeleteOldFile(file: File?): Boolean {
        return FileUtils.createFileByDeleteOldFile(file)
    }

    @JvmStatic
    fun getFsTotalSize(path: String?): Long {
        return FileUtils.getFsTotalSize(path)
    }

    @JvmStatic
    fun getFsAvailableSize(path: String?): Long {
        return FileUtils.getFsAvailableSize(path)
    }

    @JvmStatic
    fun notifySystemToScan(file: File?) {
        FileUtils.notifySystemToScan(file)
    }

    // /////////////////////////////////////////////////////////////////////////
    // ImageUtils
    // /////////////////////////////////////////////////////////////////////////
    fun bitmap2Bytes(bitmap: Bitmap?): ByteArray {
        return ImageUtils.bitmap2Bytes(bitmap)
    }

    @JvmStatic
    fun bitmap2Bytes(bitmap: Bitmap?, format: CompressFormat?, quality: Int): ByteArray {
        return ImageUtils.bitmap2Bytes(bitmap, format, quality)
    }

    @JvmStatic
    fun bytes2Bitmap(bytes: ByteArray?): Bitmap {
        return ImageUtils.bytes2Bitmap(bytes)
    }

    fun drawable2Bytes(drawable: Drawable?): ByteArray {
        return ImageUtils.drawable2Bytes(drawable)
    }

    @JvmStatic
    fun drawable2Bytes(drawable: Drawable?, format: CompressFormat?, quality: Int): ByteArray {
        return ImageUtils.drawable2Bytes(drawable, format, quality)
    }

    @JvmStatic
    fun bytes2Drawable(bytes: ByteArray?): Drawable {
        return ImageUtils.bytes2Drawable(bytes)
    }

    @JvmStatic
    fun view2Bitmap(view: View?): Bitmap {
        return ImageUtils.view2Bitmap(view)
    }

    @JvmStatic
    fun drawable2Bitmap(drawable: Drawable?): Bitmap {
        return ImageUtils.drawable2Bitmap(drawable)
    }

    @JvmStatic
    fun bitmap2Drawable(bitmap: Bitmap?): Drawable {
        return ImageUtils.bitmap2Drawable(bitmap)
    }

    // /////////////////////////////////////////////////////////////////////////
    // IntentUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun isIntentAvailable(intent: Intent?): Boolean {
        return IntentUtils.isIntentAvailable(intent)
    }

    @JvmStatic
    fun getLaunchAppIntent(pkgName: String?): Intent {
        return IntentUtils.getLaunchAppIntent(pkgName)
    }

    @JvmStatic
    fun getInstallAppIntent(file: File?): Intent {
        return IntentUtils.getInstallAppIntent(file)
    }

    @JvmStatic
    fun getInstallAppIntent(uri: Uri?): Intent {
        return IntentUtils.getInstallAppIntent(uri)
    }

    @JvmStatic
    fun getUninstallAppIntent(pkgName: String?): Intent {
        return IntentUtils.getUninstallAppIntent(pkgName)
    }

    fun getDialIntent(phoneNumber: String?): Intent {
        return IntentUtils.getDialIntent(phoneNumber)
    }

    @RequiresPermission(permission.CALL_PHONE)
    fun getCallIntent(phoneNumber: String?): Intent {
        return IntentUtils.getCallIntent(phoneNumber)
    }

    fun getSendSmsIntent(phoneNumber: String?, content: String?): Intent {
        return IntentUtils.getSendSmsIntent(phoneNumber, content)
    }

    @JvmStatic
    fun getLaunchAppDetailsSettingsIntent(pkgName: String?, isNewTask: Boolean): Intent {
        return IntentUtils.getLaunchAppDetailsSettingsIntent(pkgName, isNewTask)
    }

    // /////////////////////////////////////////////////////////////////////////
    // KeyboardUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun fixSoftInputLeaks(activity: Activity?) {
        KeyboardUtils.fixSoftInputLeaks(activity!!)
    }

    // /////////////////////////////////////////////////////////////////////////
    // NotificationUtils
    // /////////////////////////////////////////////////////////////////////////
    fun getNotification(
        channelConfig: ChannelConfig?,
        consumer: Utils.Consumer<NotificationCompat.Builder?>?
    ): Notification {
        return NotificationUtils.getNotification(channelConfig, consumer)
    }

    // /////////////////////////////////////////////////////////////////////////
    // ProcessUtils
    // /////////////////////////////////////////////////////////////////////////
    val isMainProcess: Boolean
        get() = ProcessUtils.isMainProcess()

    @JvmStatic
    val foregroundProcessName: String
        get() = ProcessUtils.getForegroundProcessName()

    @JvmStatic
    val currentProcessName: String
        get() = ProcessUtils.getCurrentProcessName()

    // /////////////////////////////////////////////////////////////////////////
    // RomUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    val isSamsung: Boolean
        get() = RomUtils.isSamsung()

    // /////////////////////////////////////////////////////////////////////////
    // ScreenUtils
    // /////////////////////////////////////////////////////////////////////////
    val appScreenWidth: Int
        get() = ScreenUtils.getAppScreenWidth()

    // /////////////////////////////////////////////////////////////////////////
    // SDCardUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    val isSDCardEnableByEnvironment: Boolean
        get() = SDCardUtils.isSDCardEnableByEnvironment()

    // /////////////////////////////////////////////////////////////////////////
    // SizeUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun dp2px(dpValue: Float): Int {
        return SizeUtils.dp2px(dpValue)
    }

    @JvmStatic
    fun px2dp(pxValue: Float): Int {
        return SizeUtils.px2dp(pxValue)
    }

    @JvmStatic
    fun sp2px(spValue: Float): Int {
        return SizeUtils.sp2px(spValue)
    }

    @JvmStatic
    fun px2sp(pxValue: Float): Int {
        return SizeUtils.px2sp(pxValue)
    }

    // /////////////////////////////////////////////////////////////////////////
    // SpUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    val spUtils4Utils: SPUtils
        get() = SPUtils.getInstance("Utils")

    // /////////////////////////////////////////////////////////////////////////
    // StringUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun isSpace(s: String?): Boolean {
        return StringUtils.isSpace(s)
    }

    @JvmStatic
    fun equals(s1: CharSequence?, s2: CharSequence?): Boolean {
        return TextUtils.equals(s1, s2)
    }

    // /////////////////////////////////////////////////////////////////////////
    // ThreadUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun <T> doAsync(task: Utils.Task<T>): Utils.Task<T> {
        ThreadUtils.getCachedPool().execute(task)
        return task
    }

    @JvmStatic
    fun runOnUiThread(runnable: Runnable?) {
        ThreadUtils.runOnUiThread(runnable)
    }

    @JvmStatic
    fun runOnUiThreadDelayed(runnable: Runnable?, delayMillis: Long) {
        ThreadUtils.runOnUiThreadDelayed(runnable, delayMillis)
    }

    // /////////////////////////////////////////////////////////////////////////
    // ThrowableUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun getFullStackTrace(throwable: Throwable?): String {
        return ThrowableUtils.getFullStackTrace(throwable)
    }

    // /////////////////////////////////////////////////////////////////////////
    // TimeUtils
    // /////////////////////////////////////////////////////////////////////////
    @JvmStatic
    fun millis2FitTimeSpan(millis: Long, precision: Int): String {
        return TimeUtils.millis2FitTimeSpan(millis, precision)
    }

    private fun preLoad(vararg runs: Runnable) {
        for (r in runs) {
            ThreadUtils.getCachedPool().execute(r)
        }
    }

    // /////////////////////////////////////////////////////////////////////////
    // Common
    // /////////////////////////////////////////////////////////////////////////
    internal class FileHead(private val mName: String) {
        private val mFirst = LinkedHashMap<String, String>()
        private val mLast = LinkedHashMap<String, String>()
        fun addFirst(key: String, value: String) {
            append2Host(mFirst, key, value)
        }

        fun append(extra: Map<String, String>?) {
            append2Host(mLast, extra)
        }

        fun append(key: String, value: String) {
            append2Host(mLast, key, value)
        }

        private fun append2Host(host: MutableMap<String, String>, extra: Map<String, String>?) {
            if (extra == null || extra.isEmpty()) {
                return
            }
            for ((key, value) in extra) {
                append2Host(host, key, value)
            }
        }

        private fun append2Host(host: MutableMap<String, String>, key: String, value: String) {
            var key = key
            if (TextUtils.isEmpty(key) || TextUtils.isEmpty(value)) {
                return
            }
            val delta = 19 - key.length // 19 is length of "Device Manufacturer"
            if (delta > 0) {
                key = key + "                   ".substring(0, delta)
            }
            host[key] = value
        }

        val appended: String
            get() {
                val sb = StringBuilder()
                for ((key, value) in mLast) {
                    sb.append(key).append(": ").append(value).append("\n")
                }
                return sb.toString()
            }

        override fun toString(): String {
            val sb = StringBuilder()
            val border = "************* $mName Head ****************\n"
            sb.append(border)
            for ((key, value) in mFirst) {
                sb.append(key).append(": ").append(value).append("\n")
            }
            sb.append("Rom Info           : ").append(RomUtils.getRomInfo()).append("\n")
            sb.append("Device Manufacturer: ").append(Build.MANUFACTURER).append("\n")
            sb.append("Device Model       : ").append(Build.MODEL).append("\n")
            sb.append("Android Version    : ").append(Build.VERSION.RELEASE).append("\n")
            sb.append("Android SDK        : ").append(Build.VERSION.SDK_INT).append("\n")
            sb.append("App VersionName    : ").append(AppUtils.getAppVersionName()).append("\n")
            sb.append("App VersionCode    : ").append(AppUtils.getAppVersionCode()).append("\n")
            sb.append(appended)
            return sb.append(border).append("\n").toString()
        }
    }
}
