/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.app

import androidx.appcompat.app.AppCompatDelegate
import androidx.multidex.MultiDexApplication
import com.facebook.stetho.Stetho
import com.netacom.base.chat.android_utils.AppUtils
import com.netacom.base.chat.android_utils.CrashUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.logger.AndroidLogAdapter
import com.netacom.base.chat.logger.FormatStrategy
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.logger.PrettyFormatStrategy

open class BaseApplication : MultiDexApplication() {

    override fun onCreate() {
        super.onCreate()
        initLogger()
        utilApp()
        setUpVectorResourceForAndroidKitkat()
    }

    private fun utilApp() {
        Utils.init(this)
        CrashUtils.init { crashInfo ->
            Logger.d("CrashUtils=$crashInfo")
            if (isProduction) AppUtils.relaunchApp()
        }
    }

    private fun initLogger() {
        val formatStrategy: FormatStrategy = PrettyFormatStrategy.newBuilder()
            .tag("Netacom")
            .build()
        Logger.addLogAdapter(
            object : AndroidLogAdapter(formatStrategy) {
                override fun isLoggable(priority: Int, tag: String?): Boolean {
                    return isShowLog
                }
            }
        )
        if (!isRelease) {
            Stetho.initializeWithDefaults(this)
        }
    }

    private fun setUpVectorResourceForAndroidKitkat() {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
    }
}
