/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.base

import com.netacom.base.chat.R
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.component.EventBus
import com.netacom.base.chat.network.ApiResponse
import com.netacom.base.chat.type.RequestStatus

data class ActionData<T>(
    var isDoing: Boolean? = null,
    var isSuccess: Boolean? = null,
    var data: T? = null,
    var message: String? = null,
    var errorCode: RequestStatus? = null,
    var code: Int = 0
) {
    fun <G> changeDataType() = ActionData<G>(
        isDoing = isDoing,
        isSuccess = isSuccess,
        message = message,
        errorCode = errorCode,
        code = code
    )

    companion object {
        fun <T> DOING(code: Int = 0) = ActionData<T>(isDoing = true, code = code)
        fun <T> SUCCESS(data: T? = null, code: Int = 0) =
            ActionData<T>(isDoing = false, isSuccess = true, data = data, code = code)

        fun <T> ERROR(message: String? = null, errorCode: RequestStatus? = null, code: Int = 0) =
            ActionData<T>(isDoing = false, isSuccess = false, message = message, errorCode = errorCode, code = code)

        fun <T> ERROR(response: ApiResponse<T>, code: Int = 0): ActionData<T> = when (response.errorCode) {
            RequestStatus.NO_INTERNET_CONNECTION.value -> {
                ERROR(
                    message = StringUtils.getString(R.string.not_have_internet_please_check_your_connection),
                    errorCode = RequestStatus.NO_INTERNET_CONNECTION,
                    code = code
                )
            }
            RequestStatus.ERROR_CLIENT.value -> {
                ERROR(
                    message = StringUtils.getString(R.string.common_error_unknown),
                    errorCode = RequestStatus.ERROR_CLIENT,
                    code = code
                )
            }
            RequestStatus.CANCEL_REQUEST.value -> {
                ERROR(
                    message = null,
                    errorCode = RequestStatus.CANCEL_REQUEST,
                    code = code
                )
            }
            RequestStatus.NO_PERMISSION.value, RequestStatus.FORBIDDEN.value -> {
                ERROR(
                    message = StringUtils.getString(R.string.no_permission_error),
                    errorCode = RequestStatus.NO_PERMISSION,
                    code = code
                )
            }
            RequestStatus.UNAUTHORIZED.value -> {
                // AppAuthentication.logOut()

                EventBus.sendEvent(
                    ActionData(
                        errorCode = RequestStatus.UNAUTHORIZED,
                        code = code
                    )
                )

                ERROR(
                    message = StringUtils.getString(R.string.common_error_unknown),
                    errorCode = RequestStatus.UNAUTHORIZED,
                    code = code
                )
            }
            else -> {
                val messages = response.message
                ERROR(
                    message = if (messages.isNullOrEmpty()) StringUtils.getString(R.string.common_error_unknown) else messages,
                    code = code
                )
            }
        }
    }
}
