/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.base.chat.base

import android.annotation.SuppressLint
import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.annotation.LayoutRes
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.LiveData
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.google.android.material.snackbar.Snackbar
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.R
import com.netacom.base.chat.android_utils.ScreenUtils
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.base.chat.livedata.EventObserver
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import java.util.Timer
import java.util.TimerTask

abstract class BaseDialogBottomFragment<DB : ViewDataBinding, VM : BaseViewModel>(
    @LayoutRes val layoutID: Int,
    private val viewModelClass: Class<VM>
) : BottomSheetDialogFragment() {
    private fun getViewVM(): VM = ViewModelProvider(requireActivity()).get(viewModelClass)
    protected abstract fun setLayoutHeight(): Int
    protected abstract fun setViewModel(): Int
    private var _binding: DB? = null
    val binding get() = _binding!!
    lateinit var viewModel: VM
    var isLayout: Int = DialogDef.LAYOUT_NORMAL
    var allowDraggable: Boolean = true
    @SuppressLint("UseCompatLoadingForDrawables")
    override fun onStart() {
        super.onStart()
        dialog?.window?.apply {
            setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
            // setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_MODE_CHANGED)
        }
        (view?.parent as? View)?.apply {
            BottomSheetBehavior.from(this).apply {
                if (!allowDraggable) {
                    isDraggable = false
                    dialog?.setCanceledOnTouchOutside(false)
                }
                when (isLayout) {
                    DialogDef.LAYOUT_SMALL -> setPeekHeight(ScreenUtils.getScreenHeight() / 2, true)
                    DialogDef.LAYOUT_NORMAL -> setPeekHeight(
                        (ScreenUtils.getScreenHeight() / 1.3).toInt(),
                        true
                    )
                    DialogDef.LAYOUT_FULL -> {
                        val sheetContainer = requireView().parent as? ViewGroup ?: return
                        sheetContainer.layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT
                        setPeekHeight(ScreenUtils.getScreenHeight(), true)
                        state = BottomSheetBehavior.STATE_EXPANDED
                    }
                    DialogDef.LAYOUT_WRAP_CONTENT -> {
                        val sheetContainer = requireView().parent as? ViewGroup ?: return
                        sheetContainer.layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT
                        setPeekHeight(ScreenUtils.getScreenHeight(), true)
                        state = BottomSheetBehavior.STATE_EXPANDED
                    }
                }
                isDraggable = allowDraggable
            }
        } ?: run {
            FirebaseCrashlytics.getInstance().recordException(NullPointerException("BaseDialogBottomFragment:BottomSheetBehavior:Null"))
        }
    }

    override fun getTheme(): Int = R.style.BottomSheetDialogTheme

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog = BottomSheetDialog(requireContext(), theme)

        return dialog
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        super.onCreateView(inflater, container, savedInstanceState)
        _binding = DataBindingUtil.inflate(inflater, layoutID, container, false)
        viewModel = getViewVM()
        isLayout = setLayoutHeight()
        _binding?.apply {
            setVariable(setViewModel(), viewModel)
            lifecycleOwner = this@BaseDialogBottomFragment
        }
        dialog?.setOnShowListener { _dialogInterface ->
            val bottomSheetDialog = _dialogInterface as BottomSheetDialog
            setColorNavigationBar(bottomSheetDialog)
        }
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initViews()
        initData()
        setupTheme()
    }

    protected abstract fun initViews()

    protected abstract fun initData()

    protected abstract fun setupTheme()

    open fun setColorNavigationBar(dialog: Dialog) {
    }

    fun <T> showSnackBar(
        text: T,
        textAction: Int? = null,
        action: View.OnClickListener? = null,
        currentView: View? = null
    ) {
        val view = currentView ?: activity?.findViewById<View>(android.R.id.content)
        view?.let {
            val snackBar = when (text) {
                is Int -> Snackbar.make(it, getString(text), Snackbar.LENGTH_LONG)
                else -> Snackbar.make(it, text.toString(), Snackbar.LENGTH_LONG)
            }
            if (textAction != null && action != null) {
                snackBar.setAction(getString(textAction), action)
            }
            snackBar.show()
        }
    }

    fun <T> LiveData<T>.observe(listener: (T) -> (Unit)) {
        observe(this@BaseDialogBottomFragment, { listener.invoke(it) })
    }

    inline fun <T> LiveData<EventLiveData<T>>.observeOnce(crossinline onChanged: (T) -> (Unit)) {
        observe(
            viewLifecycleOwner,
            EventObserver { value ->
                onChanged(value)
            }
        )
    }

    override fun onDestroyView() {
        dialog?.dismiss()
        _binding = null
        super.onDestroyView()
    }

    private var isShowCustomError = false
    fun showCustomError(view: AppCompatTextView, text: String) {
        if (!isShowCustomError) {
            isShowCustomError = true
            view.text = text
            view.isVisible = true
            Timer().schedule(
                object : TimerTask() {
                    override fun run() {
                        CoroutineScope(Dispatchers.Main).launch {
                            view.isGone = true
                            isShowCustomError = false
                        }
                    }
                },
                3000
            )
        }
    }
}
