/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

@file:Suppress("UNUSED_PARAMETER")

package com.netacom.base.chat.binding

import android.view.View
import android.widget.TextView
import androidx.annotation.Keep
import androidx.core.view.isVisible
import androidx.databinding.BindingAdapter
import com.netacom.base.chat.R
import com.netacom.base.chat.android_utils.ClickUtils
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.model.ScreenStateObj
import com.netacom.base.chat.type.ScreenState

/**
 * Data Binding adapters specific to the com.netacom.com.netacom.base.chat.app.
 */

@set:BindingAdapter("visible")
var View.visibleOrGone
    get() = visibility == View.VISIBLE
    set(value) {
        isVisible = value
    }

@set:BindingAdapter("invisible")
var View.visibleOrInvisible
    get() = visibility == View.INVISIBLE
    set(value) {
        visibility = if (value) View.INVISIBLE else View.VISIBLE
    }

@Keep
@BindingAdapter("clickDebounce")
fun View.clickDebounce(listenerBlock: View.OnClickListener) {
    ClickUtils.applyPressedViewScale(this)
    ClickUtils.applySingleDebouncing(this, 500, listenerBlock)
}

@Keep
@BindingAdapter("clickDebounceWithoutScale")
fun View.clickDebounceWithoutScale(listenerBlock: View.OnClickListener) {
    ClickUtils.applySingleDebouncing(this, 500, listenerBlock)
}

@BindingAdapter(
    value = ["screenState", "onTextClick"],
    requireAll = false
)
fun <T> setText(
    view: TextView,
    screenStateObj: ScreenStateObj?,
    onTextClick: (() -> Unit)?
) {
    screenStateObj?.let { obj ->
        obj.message?.let { msg ->
            if (obj.state == ScreenState.ERROR || obj.state == ScreenState.NO_INTERNET || obj.state == ScreenState.NO_PERMISSION) {
                view.text = when (msg) {
                    is Int -> StringUtils.getString(msg)
                    else -> msg.toString()
                }
                view.visibility = View.VISIBLE
            }
        } ?: run {
            val stringRes = when (screenStateObj.state) {
                ScreenState.EMPTY, ScreenState.REFRESH_EMPTY -> R.string.empty_list
                ScreenState.NOT_FOUND -> R.string.not_found
                ScreenState.EMPTY_FILTER -> R.string.empty_filter
                ScreenState.ERROR -> R.string.common_error_unknown
                ScreenState.NO_INTERNET -> R.string.not_have_internet_please_check_your_connection
                ScreenState.LOGIN_REQUIRED -> R.string.login_required
                else -> null
            }
            stringRes?.let { res ->
                view.visibility = View.VISIBLE
                view.setText(res)
            } ?: run {
                view.visibility = View.GONE
            }
        }
    }
    onTextClick?.let {
        view.isClickable = true
        view.isFocusable = true
        view.clickDebounce {
            onTextClick.invoke()
        }
    }
}
